/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.org.apache.commons.validator.routines.checkdigit;

import org.apache.ozone.shaded.org.apache.commons.validator.GenericValidator;
import org.apache.ozone.shaded.org.apache.commons.validator.routines.CodeValidator;
import org.apache.ozone.shaded.org.apache.commons.validator.routines.checkdigit.CheckDigit;
import org.apache.ozone.shaded.org.apache.commons.validator.routines.checkdigit.CheckDigitException;
import org.apache.ozone.shaded.org.apache.commons.validator.routines.checkdigit.ModulusCheckDigit;

public final class ECNumberCheckDigit
extends ModulusCheckDigit {
    private static final long serialVersionUID = 7265356024784308367L;
    private static final ECNumberCheckDigit INSTANCE = new ECNumberCheckDigit();
    private static final String GROUP = "(\\d{3})";
    private static final String DASH = "(?:\\-)";
    static final String EC_REGEX = "^(?:(\\d{3})(?:\\-)(\\d{3})(?:\\-)(\\d))$";
    private static final int EC_LEN = 7;
    static final CodeValidator REGEX_VALIDATOR = new CodeValidator("^(?:(\\d{3})(?:\\-)(\\d{3})(?:\\-)(\\d))$", 7, null);

    public static CheckDigit getInstance() {
        return INSTANCE;
    }

    private ECNumberCheckDigit() {
        super(11);
    }

    @Override
    public String calculate(String code) throws CheckDigitException {
        if (GenericValidator.isBlankOrNull(code)) {
            throw new CheckDigitException("Code is missing");
        }
        int modulusResult = INSTANCE.calculateModulus(code, false);
        return this.toCheckDigit(modulusResult);
    }

    @Override
    public boolean isValid(String code) {
        if (GenericValidator.isBlankOrNull(code)) {
            return false;
        }
        Object cde = REGEX_VALIDATOR.validate(code);
        if (!(cde instanceof String)) {
            return false;
        }
        try {
            int modulusResult = INSTANCE.calculateModulus((String)cde, true);
            return modulusResult == Character.getNumericValue(code.charAt(code.length() - 1));
        }
        catch (CheckDigitException ex) {
            return false;
        }
    }

    @Override
    protected int weightedValue(int charValue, int leftPos, int rightPos) {
        return leftPos >= 7 ? 0 : charValue * leftPos;
    }
}

