/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.io.opentelemetry.sdk.trace.samplers;

import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.ozone.shaded.io.opentelemetry.api.common.Attributes;
import org.apache.ozone.shaded.io.opentelemetry.api.trace.Span;
import org.apache.ozone.shaded.io.opentelemetry.api.trace.SpanContext;
import org.apache.ozone.shaded.io.opentelemetry.api.trace.SpanKind;
import org.apache.ozone.shaded.io.opentelemetry.context.Context;
import org.apache.ozone.shaded.io.opentelemetry.sdk.trace.data.LinkData;
import org.apache.ozone.shaded.io.opentelemetry.sdk.trace.samplers.Sampler;
import org.apache.ozone.shaded.io.opentelemetry.sdk.trace.samplers.SamplingResult;

@Immutable
final class ParentBasedSampler
implements Sampler {
    private final Sampler root;
    private final Sampler remoteParentSampled;
    private final Sampler remoteParentNotSampled;
    private final Sampler localParentSampled;
    private final Sampler localParentNotSampled;

    ParentBasedSampler(Sampler root, @Nullable Sampler remoteParentSampled, @Nullable Sampler remoteParentNotSampled, @Nullable Sampler localParentSampled, @Nullable Sampler localParentNotSampled) {
        this.root = root;
        this.remoteParentSampled = remoteParentSampled == null ? Sampler.alwaysOn() : remoteParentSampled;
        this.remoteParentNotSampled = remoteParentNotSampled == null ? Sampler.alwaysOff() : remoteParentNotSampled;
        this.localParentSampled = localParentSampled == null ? Sampler.alwaysOn() : localParentSampled;
        this.localParentNotSampled = localParentNotSampled == null ? Sampler.alwaysOff() : localParentNotSampled;
    }

    @Override
    public SamplingResult shouldSample(Context parentContext, String traceId, String name, SpanKind spanKind, Attributes attributes, List<LinkData> parentLinks) {
        SpanContext parentSpanContext = Span.fromContext(parentContext).getSpanContext();
        if (!parentSpanContext.isValid()) {
            return this.root.shouldSample(parentContext, traceId, name, spanKind, attributes, parentLinks);
        }
        if (parentSpanContext.isRemote()) {
            return parentSpanContext.isSampled() ? this.remoteParentSampled.shouldSample(parentContext, traceId, name, spanKind, attributes, parentLinks) : this.remoteParentNotSampled.shouldSample(parentContext, traceId, name, spanKind, attributes, parentLinks);
        }
        return parentSpanContext.isSampled() ? this.localParentSampled.shouldSample(parentContext, traceId, name, spanKind, attributes, parentLinks) : this.localParentNotSampled.shouldSample(parentContext, traceId, name, spanKind, attributes, parentLinks);
    }

    @Override
    public String getDescription() {
        return String.format("ParentBased{root:%s,remoteParentSampled:%s,remoteParentNotSampled:%s,localParentSampled:%s,localParentNotSampled:%s}", this.root.getDescription(), this.remoteParentSampled.getDescription(), this.remoteParentNotSampled.getDescription(), this.localParentSampled.getDescription(), this.localParentNotSampled.getDescription());
    }

    public String toString() {
        return this.getDescription();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ParentBasedSampler)) {
            return false;
        }
        ParentBasedSampler that = (ParentBasedSampler)o;
        return this.root.equals(that.root) && this.remoteParentSampled.equals(that.remoteParentSampled) && this.remoteParentNotSampled.equals(that.remoteParentNotSampled) && this.localParentSampled.equals(that.localParentSampled) && this.localParentNotSampled.equals(that.localParentNotSampled);
    }

    public int hashCode() {
        int result2 = this.root.hashCode();
        result2 = 31 * result2 + this.remoteParentSampled.hashCode();
        result2 = 31 * result2 + this.remoteParentNotSampled.hashCode();
        result2 = 31 * result2 + this.localParentSampled.hashCode();
        result2 = 31 * result2 + this.localParentNotSampled.hashCode();
        return result2;
    }
}

