/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.io.opentelemetry.sdk.logs.data;

import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.ozone.shaded.io.opentelemetry.api.common.Attributes;
import org.apache.ozone.shaded.io.opentelemetry.api.common.Value;
import org.apache.ozone.shaded.io.opentelemetry.api.logs.Severity;
import org.apache.ozone.shaded.io.opentelemetry.api.trace.SpanContext;
import org.apache.ozone.shaded.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import org.apache.ozone.shaded.io.opentelemetry.sdk.logs.data.Body;
import org.apache.ozone.shaded.io.opentelemetry.sdk.resources.Resource;

@Immutable
public interface LogRecordData {
    public Resource getResource();

    public InstrumentationScopeInfo getInstrumentationScopeInfo();

    public long getTimestampEpochNanos();

    public long getObservedTimestampEpochNanos();

    public SpanContext getSpanContext();

    public Severity getSeverity();

    @Nullable
    public String getSeverityText();

    @Deprecated
    public Body getBody();

    @Nullable
    default public Value<?> getBodyValue() {
        Body body = this.getBody();
        return body.getType() == Body.Type.EMPTY ? null : Value.of(body.asString());
    }

    public Attributes getAttributes();

    public int getTotalAttributeCount();

    @Nullable
    default public String getEventName() {
        return null;
    }
}

