/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.io.opentelemetry.sdk.internal;

import javax.annotation.Nullable;
import org.apache.ozone.shaded.io.opentelemetry.api.common.AttributeKey;
import org.apache.ozone.shaded.io.opentelemetry.api.internal.ConfigUtil;
import org.apache.ozone.shaded.io.opentelemetry.sdk.internal.DefaultExceptionAttributeResolver;

public interface ExceptionAttributeResolver {
    public static final AttributeKey<String> EXCEPTION_TYPE = AttributeKey.stringKey("exception.type");
    public static final AttributeKey<String> EXCEPTION_MESSAGE = AttributeKey.stringKey("exception.message");
    public static final AttributeKey<String> EXCEPTION_STACKTRACE = AttributeKey.stringKey("exception.stacktrace");

    public void setExceptionAttributes(AttributeSetter var1, Throwable var2, int var3);

    public static ExceptionAttributeResolver getDefault() {
        return ExceptionAttributeResolver.getDefault(Boolean.parseBoolean(ConfigUtil.getString("otel.experimental.sdk.jvm_stacktrace", "false")));
    }

    public static ExceptionAttributeResolver getDefault(boolean jvmStacktraceEnabled) {
        return new DefaultExceptionAttributeResolver(jvmStacktraceEnabled);
    }

    public static interface AttributeSetter {
        public <T> void setAttribute(AttributeKey<T> var1, @Nullable T var2);
    }
}

