/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.io.opentelemetry.exporter.otlp.trace;

import java.util.Collection;
import java.util.StringJoiner;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.grpc.GrpcExporter;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.grpc.GrpcExporterBuilder;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.marshal.Marshaler;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.otlp.traces.SpanReusableDataMarshaler;
import org.apache.ozone.shaded.io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporterBuilder;
import org.apache.ozone.shaded.io.opentelemetry.sdk.common.CompletableResultCode;
import org.apache.ozone.shaded.io.opentelemetry.sdk.common.export.MemoryMode;
import org.apache.ozone.shaded.io.opentelemetry.sdk.trace.data.SpanData;
import org.apache.ozone.shaded.io.opentelemetry.sdk.trace.export.SpanExporter;

@ThreadSafe
public final class OtlpGrpcSpanExporter
implements SpanExporter {
    private final GrpcExporterBuilder<Marshaler> builder;
    private final GrpcExporter<Marshaler> delegate;
    private final SpanReusableDataMarshaler marshaler;

    public static OtlpGrpcSpanExporter getDefault() {
        return OtlpGrpcSpanExporter.builder().build();
    }

    public static OtlpGrpcSpanExporterBuilder builder() {
        return new OtlpGrpcSpanExporterBuilder();
    }

    OtlpGrpcSpanExporter(GrpcExporterBuilder<Marshaler> builder, GrpcExporter<Marshaler> delegate, MemoryMode memoryMode) {
        this.builder = builder;
        this.delegate = delegate;
        this.marshaler = new SpanReusableDataMarshaler(memoryMode, delegate::export);
    }

    public OtlpGrpcSpanExporterBuilder toBuilder() {
        return new OtlpGrpcSpanExporterBuilder(this.builder.copy(), this.marshaler.getMemoryMode());
    }

    @Override
    public CompletableResultCode export(Collection<SpanData> spans) {
        return this.marshaler.export(spans);
    }

    @Override
    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode shutdown() {
        return this.delegate.shutdown();
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", "OtlpGrpcSpanExporter{", "}");
        joiner.add(this.builder.toString(false));
        joiner.add("memoryMode=" + (Object)((Object)this.marshaler.getMemoryMode()));
        return joiner.toString();
    }
}

