/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.util;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.ozone.util.RadixNode;
import org.apache.ozone.shaded.com.google.common.annotations.VisibleForTesting;

public class RadixTree<T> {
    private static final String PATH_DELIMITER = "/";
    private RadixNode root = new RadixNode("/");

    public boolean isEmpty() {
        return this.root.hasChildren();
    }

    public void insert(String path) {
        this.insert(path, null);
    }

    public void insert(String path, T val) {
        RadixNode<T> n = this.root;
        Path p = Paths.get(path, new String[0]);
        for (int level = 0; level < p.getNameCount(); ++level) {
            String component;
            HashMap<String, RadixNode> child = n.getChildren();
            if (child.containsKey(component = p.getName(level).toString())) {
                n = child.get(component);
                continue;
            }
            RadixNode<T> tmp = new RadixNode<T>(component);
            child.put(component, tmp);
            n = tmp;
        }
        if (val != null) {
            n.setValue(val);
        }
    }

    public RadixNode<T> getLastNodeInPrefixPath(String path) {
        List<RadixNode<T>> lpp = this.getLongestPrefixPath(path);
        Path p = Paths.get(path, new String[0]);
        if (lpp.size() != p.getNameCount() + 1) {
            return null;
        }
        return lpp.get(p.getNameCount());
    }

    public void removePrefixPath(String path) {
        Path p = Paths.get(path, new String[0]);
        this.removePrefixPathInternal(this.root, p, 0);
    }

    private boolean removePrefixPathInternal(RadixNode<T> current, Path path, int level) {
        if (level == path.getNameCount()) {
            return current.hasChildren();
        }
        String name = path.getName(level).toString();
        RadixNode node = current.getChildren().get(name);
        if (node == null) {
            return false;
        }
        if (this.removePrefixPathInternal(node, path, level + 1)) {
            current.getChildren().remove(name);
            return current.hasChildren();
        }
        return false;
    }

    public List<RadixNode<T>> getLongestPrefixPath(String path) {
        String component;
        HashMap<String, RadixNode> children;
        RadixNode n = this.root;
        Path p = Paths.get(path, new String[0]);
        ArrayList<RadixNode<T>> result2 = new ArrayList<RadixNode<T>>();
        result2.add(this.root);
        for (int level = 0; level < p.getNameCount() && !(children = n.getChildren()).isEmpty() && children.containsKey(component = p.getName(level).toString()); ++level) {
            n = children.get(component);
            result2.add(n);
        }
        return result2;
    }

    @VisibleForTesting
    public static String radixPathToString(List<RadixNode<Integer>> path) {
        StringBuilder sb = new StringBuilder();
        for (RadixNode<Integer> n : path) {
            sb.append(n.getName());
            sb.append(n.getName().equals(PATH_DELIMITER) ? "" : PATH_DELIMITER);
        }
        return sb.toString();
    }

    public String getLongestPrefix(String path) {
        String component;
        HashMap<String, RadixNode> children;
        int level;
        RadixNode n = this.root;
        Path p = Paths.get(path, new String[0]);
        for (level = 0; level < p.getNameCount() && !(children = n.getChildren()).isEmpty() && children.containsKey(component = p.getName(level).toString()); ++level) {
            n = children.get(component);
        }
        if (level >= 1) {
            Path longestMatch = Paths.get(this.root.getName(), new String[0]).resolve(p.subpath(0, level));
            String ret = longestMatch.toString();
            return path.endsWith(PATH_DELIMITER) ? ret + PATH_DELIMITER : ret;
        }
        return this.root.getName();
    }
}

