/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.OzoneClientConfig;
import org.apache.hadoop.hdds.scm.XceiverClientFactory;
import org.apache.hadoop.hdds.scm.storage.BlockExtendedInputStream;
import org.apache.hadoop.hdds.scm.storage.BlockLocationInfo;
import org.apache.hadoop.hdds.scm.storage.ByteReaderStrategy;
import org.apache.hadoop.io.ByteBufferPool;
import org.apache.hadoop.ozone.client.io.BadDataLocationException;
import org.apache.hadoop.ozone.client.io.BlockInputStreamFactory;
import org.apache.hadoop.ozone.client.io.ECBlockInputStream;
import org.apache.hadoop.ozone.client.io.InsufficientLocationsException;
import org.apache.ozone.erasurecode.rawcoder.RawErasureDecoder;
import org.apache.ozone.erasurecode.rawcoder.util.CodecUtil;
import org.apache.ozone.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.ozone.shaded.org.apache.commons.lang3.NotImplementedException;
import org.apache.ozone.shaded.org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.ozone.shaded.org.apache.ratis.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ECBlockReconstructedStripeInputStream
extends ECBlockInputStream {
    private static final Logger LOG = LoggerFactory.getLogger(ECBlockReconstructedStripeInputStream.class);
    private ByteBuffer[] decoderInputBuffers;
    private ByteBuffer[] decoderOutputBuffers;
    private final SortedSet<Integer> missingIndexes = new TreeSet<Integer>();
    private final SortedSet<Integer> dataIndexes;
    private final SortedSet<Integer> paddingIndexes;
    private final SortedSet<Integer> parityIndexes;
    private final SortedSet<Integer> allIndexes;
    private final SortedSet<Integer> selectedIndexes = new TreeSet<Integer>();
    private final SortedSet<Integer> internalBuffers = new TreeSet<Integer>();
    private final Set<Integer> failedDataIndexes = new TreeSet<Integer>();
    private final ByteBufferPool byteBufferPool;
    private RawErasureDecoder decoder;
    private boolean initialized = false;
    private final ExecutorService executor;
    private final Set<Integer> recoveryIndexes = new TreeSet<Integer>();

    public ECBlockReconstructedStripeInputStream(ECReplicationConfig repConfig, BlockLocationInfo blockInfo, XceiverClientFactory xceiverClientFactory, Function<BlockID, BlockLocationInfo> refreshFunction, BlockInputStreamFactory streamFactory, ByteBufferPool byteBufferPool, ExecutorService ecReconstructExecutor, OzoneClientConfig config) {
        super(repConfig, blockInfo, xceiverClientFactory, refreshFunction, streamFactory, config);
        this.byteBufferPool = byteBufferPool;
        this.executor = ecReconstructExecutor;
        int expectedDataBlocks = this.calculateExpectedDataBlocks(repConfig);
        int d = repConfig.getData();
        this.dataIndexes = ECBlockReconstructedStripeInputStream.setOfRange(0, expectedDataBlocks);
        this.paddingIndexes = ECBlockReconstructedStripeInputStream.setOfRange(expectedDataBlocks, d);
        this.parityIndexes = ECBlockReconstructedStripeInputStream.setOfRange(d, repConfig.getRequiredNodes());
        this.allIndexes = ECBlockReconstructedStripeInputStream.setOfRange(0, repConfig.getRequiredNodes());
    }

    public synchronized void addFailedDatanodes(Collection<DatanodeDetails> dns) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot add failed datanodes after the reader has been initialized");
        }
        DatanodeDetails[] locations = this.getDataLocations();
        block0: for (DatanodeDetails dn : dns) {
            for (int i = 0; i < locations.length; ++i) {
                if (locations[i] == null || !locations[i].equals(dn)) continue;
                this.failedDataIndexes.add(i);
                continue block0;
            }
        }
        LOG.debug("{}: set failed indexes {}", (Object)this, this.failedDataIndexes);
    }

    public synchronized Set<Integer> getFailedIndexes() {
        return new HashSet<Integer>(this.failedDataIndexes);
    }

    public synchronized void setRecoveryIndexes(Collection<Integer> indexes) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot set recovery indexes after the reader has been initialized");
        }
        Preconditions.assertNotNull(indexes, "recovery indexes");
        this.recoveryIndexes.clear();
        this.recoveryIndexes.addAll(indexes);
        LOG.debug("{}: set recovery indexes {}", (Object)this, this.recoveryIndexes);
    }

    private void init() throws InsufficientLocationsException {
        this.initialized = false;
        if (this.decoder == null) {
            this.decoder = CodecUtil.createRawDecoderWithFallback(this.getRepConfig());
        }
        if (!this.hasSufficientLocations()) {
            String msg = "There are insufficient datanodes to read the EC block";
            LOG.debug("{}: {}", (Object)this, (Object)msg);
            throw new InsufficientLocationsException(msg);
        }
        this.allocateInternalBuffers();
        if (!this.isOfflineRecovery()) {
            this.decoderOutputBuffers = new ByteBuffer[this.missingIndexes.size()];
        }
        this.initialized = true;
    }

    private void allocateInternalBuffers() {
        int minIndex;
        for (int i = minIndex = this.isOfflineRecovery() ? 0 : this.getRepConfig().getData(); i < this.getRepConfig().getRequiredNodes(); ++i) {
            boolean hasBuffer;
            boolean internalInput = this.selectedIndexes.contains(i) || this.paddingIndexes.contains(i);
            boolean bl = hasBuffer = this.decoderInputBuffers[i] != null;
            if (internalInput && !hasBuffer) {
                this.allocateInternalBuffer(i);
                continue;
            }
            if (internalInput || !hasBuffer) continue;
            this.releaseInternalBuffer(i);
        }
    }

    private void allocateInternalBuffer(int index) {
        Preconditions.assertTrue(this.internalBuffers.add(index), () -> "Buffer " + index + " already tracked as internal input");
        this.decoderInputBuffers[index] = this.byteBufferPool.getBuffer(false, this.getRepConfig().getEcChunkSize());
    }

    private void releaseInternalBuffer(int index) {
        Preconditions.assertTrue(this.internalBuffers.remove(index), () -> "Buffer " + index + " not tracked as internal input");
        this.byteBufferPool.putBuffer(this.decoderInputBuffers[index]);
        this.decoderInputBuffers[index] = null;
    }

    private void markMissingLocationsAsFailed() {
        DatanodeDetails[] locations = this.getDataLocations();
        for (int i = 0; i < locations.length; ++i) {
            if (locations[i] != null || !this.failedDataIndexes.add(i)) continue;
            LOG.debug("{}: marked [{}] as failed", (Object)this, (Object)i);
        }
    }

    private boolean isOfflineRecovery() {
        return !this.recoveryIndexes.isEmpty();
    }

    private void assignBuffers(ByteBuffer[] bufs) {
        Preconditions.assertSame(this.getExpectedBufferCount(), bufs.length, "buffer count");
        if (this.isOfflineRecovery()) {
            this.decoderOutputBuffers = bufs;
        } else {
            int recoveryIndex = 0;
            for (int i = 0; i < bufs.length; ++i) {
                if (this.isMissingIndex(i)) {
                    this.decoderOutputBuffers[recoveryIndex++] = bufs[i];
                    if (this.internalBuffers.contains(i)) {
                        this.releaseInternalBuffer(i);
                        continue;
                    }
                    this.decoderInputBuffers[i] = null;
                    continue;
                }
                this.decoderInputBuffers[i] = bufs[i];
            }
        }
    }

    private int getExpectedBufferCount() {
        return this.isOfflineRecovery() ? this.recoveryIndexes.size() : this.getRepConfig().getData();
    }

    private boolean isMissingIndex(int ind) {
        return this.missingIndexes.contains(ind);
    }

    public synchronized int recoverChunks(ByteBuffer[] bufs) throws IOException {
        Preconditions.assertTrue(this.isOfflineRecovery());
        return this.read(bufs);
    }

    public synchronized int readStripe(ByteBuffer[] bufs) throws IOException {
        return this.read(bufs);
    }

    @VisibleForTesting
    synchronized int read(ByteBuffer[] bufs) throws IOException {
        int toRead = (int)Math.min(this.getRemaining(), this.getStripeSize());
        if (toRead == 0) {
            return -1;
        }
        if (!this.initialized) {
            this.init();
        }
        this.validateBuffers(bufs);
        while (true) {
            try {
                this.assignBuffers(bufs);
                this.clearInternalBuffers();
                this.setBufferReadLimits(toRead);
                this.loadDataBuffersFromStream();
            }
            catch (IOException e) {
                this.seek(this.getPos());
                for (ByteBuffer b : bufs) {
                    b.position(0);
                }
                this.init();
                continue;
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new IOException("Interrupted waiting for reads to complete", ie);
            }
            break;
        }
        if (!this.missingIndexes.isEmpty()) {
            this.padBuffers(toRead);
            this.flipInputs();
            this.decodeStripe();
            this.setBufferReadLimits(toRead);
        } else {
            this.flipInputs();
        }
        this.setPos(this.getPos() + (long)toRead);
        if (this.remaining() == 0L) {
            this.freeAllResourcesWithoutClosing();
        }
        return toRead;
    }

    private void validateBuffers(ByteBuffer[] bufs) {
        Preconditions.assertSame(this.getExpectedBufferCount(), bufs.length, "buffer count");
        int chunkSize = this.getRepConfig().getEcChunkSize();
        for (ByteBuffer b : bufs) {
            Preconditions.assertSame(chunkSize, b.remaining(), "buf.remaining");
        }
    }

    private void padBuffers(int toRead) {
        int i;
        int dataNum = this.getRepConfig().getData();
        int parityNum = this.getRepConfig().getParity();
        int chunkSize = this.getRepConfig().getEcChunkSize();
        if ((long)toRead >= this.getStripeSize()) {
            return;
        }
        int fullChunks = toRead / chunkSize;
        int paritySize = Math.min(toRead, chunkSize);
        for (i = fullChunks = Math.max(1, fullChunks); i < dataNum; ++i) {
            ByteBuffer buf = this.decoderInputBuffers[i];
            if (buf == null) continue;
            buf.limit(paritySize);
            this.zeroFill(buf);
        }
        for (i = dataNum; i < dataNum + parityNum; ++i) {
            ByteBuffer b = this.decoderInputBuffers[i];
            if (b == null) continue;
            Preconditions.assertSame(paritySize, b.position(), "buf.position");
        }
        for (ByteBuffer b : this.decoderOutputBuffers) {
            b.limit(paritySize);
        }
    }

    private void setBufferReadLimits(int toRead) {
        int data;
        int chunkSize = this.getRepConfig().getEcChunkSize();
        int fullChunks = toRead / chunkSize;
        if (fullChunks == (data = this.getRepConfig().getData())) {
            return;
        }
        int partialLength = toRead % chunkSize;
        this.setReadLimits(partialLength, fullChunks, this.decoderInputBuffers, this.allIndexes);
        this.setReadLimits(partialLength, fullChunks, this.decoderOutputBuffers, this.missingIndexes);
    }

    private void setReadLimits(int partialChunkSize, int fullChunks, ByteBuffer[] buffers, Collection<Integer> indexes) {
        int data = this.getRepConfig().getData();
        Preconditions.assertTrue(buffers.length == indexes.size(), "Mismatch: %d buffers but %d indexes", buffers.length, indexes.size());
        Iterator<ByteBuffer> iter = Arrays.asList(buffers).iterator();
        for (int i : indexes) {
            ByteBuffer buf = iter.next();
            if (buf == null) continue;
            if (i == fullChunks) {
                buf.limit(partialChunkSize);
                continue;
            }
            if (fullChunks < i && i < data) {
                buf.position(0);
                buf.limit(0);
                continue;
            }
            if (data > i || fullChunks != 0) continue;
            buf.limit(partialChunkSize);
        }
    }

    private void zeroFill(ByteBuffer buf) {
        if (buf.hasArray()) {
            byte[] a = buf.array();
            Arrays.fill(a, buf.position(), buf.limit(), (byte)0);
            buf.position(buf.limit());
        } else {
            while (buf.hasRemaining()) {
                buf.put((byte)0);
            }
        }
    }

    private SortedSet<Integer> selectInternalInputs(SortedSet<Integer> available, long count) {
        if (count <= 0L) {
            return Collections.emptySortedSet();
        }
        if ((long)available.size() == count) {
            return available;
        }
        TreeSet<Integer> selected = new TreeSet<Integer>();
        Iterator iterator2 = available.iterator();
        while (iterator2.hasNext()) {
            int i = (Integer)iterator2.next();
            if (this.decoderInputBuffers[i] == null) continue;
            selected.add(i);
        }
        ArrayList<Integer> candidates = new ArrayList<Integer>(available);
        candidates.removeAll(selected);
        Collections.shuffle(candidates);
        selected.addAll(candidates.stream().limit(count - (long)selected.size()).collect(Collectors.toSet()));
        return selected;
    }

    private void flipInputs() {
        for (ByteBuffer b : this.decoderInputBuffers) {
            if (b == null) continue;
            b.flip();
        }
    }

    private void clearInternalBuffers() {
        Iterator iterator2 = this.internalBuffers.iterator();
        while (iterator2.hasNext()) {
            int i = (Integer)iterator2.next();
            if (this.decoderInputBuffers[i] == null) continue;
            this.decoderInputBuffers[i].clear();
            this.decoderInputBuffers[i].limit(this.getRepConfig().getEcChunkSize());
        }
    }

    protected void loadDataBuffersFromStream() throws IOException, InterruptedException {
        ArrayDeque<ImmutablePair<Integer, Future<Void>>> pendingReads = new ArrayDeque<ImmutablePair<Integer, Future<Void>>>();
        Iterator iterator2 = this.selectedIndexes.iterator();
        while (iterator2.hasNext()) {
            int i = (Integer)iterator2.next();
            ByteBuffer buf = this.decoderInputBuffers[i];
            pendingReads.add(new ImmutablePair<Integer, Future<Void>>(i, this.executor.submit(() -> {
                this.readIntoBuffer(i, buf);
                return null;
            })));
        }
        boolean exceptionOccurred = false;
        while (!pendingReads.isEmpty()) {
            int index = -1;
            try {
                ImmutablePair pair = (ImmutablePair)pendingReads.poll();
                index = (Integer)pair.getKey();
                ((Future)pair.getValue()).get();
            }
            catch (ExecutionException ee) {
                boolean added = this.failedDataIndexes.add(index);
                Throwable t2 = ee.getCause() != null ? ee.getCause() : ee;
                String msg = "{}: error reading [{}]";
                msg = added ? msg + ", marked as failed" : msg + ", already had failed";
                LOG.info(msg, new Object[]{this, index, t2});
                exceptionOccurred = true;
            }
            catch (InterruptedException ie) {
                LOG.debug("{}: interrupted while waiting for reads to complete", (Object)this, (Object)ie);
                Thread.currentThread().interrupt();
            }
        }
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException("Interrupted while waiting for reads to complete");
        }
        if (exceptionOccurred) {
            throw new IOException("One or more errors occurred reading block " + this.getBlockID());
        }
    }

    private void readIntoBuffer(int ind, ByteBuffer buf) throws IOException {
        LinkedList<DatanodeDetails> failedLocations = new LinkedList<DatanodeDetails>();
        while (true) {
            int currentBufferPosition = buf.position();
            try {
                this.readFromCurrentLocation(ind, buf);
            }
            catch (IOException e) {
                DatanodeDetails failedLocation = this.getDataLocations()[ind];
                failedLocations.add(failedLocation);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{}: read [{}] failed from {} due to {}", new Object[]{this, ind, failedLocation, e.getMessage()});
                }
                this.closeStream(ind);
                if (this.shouldRetryFailedRead(ind)) {
                    buf.position(currentBufferPosition);
                    continue;
                }
                throw new BadDataLocationException(ind, e, failedLocations);
            }
            break;
        }
    }

    private void readFromCurrentLocation(int ind, ByteBuffer buf) throws IOException {
        BlockExtendedInputStream stream = this.getOrOpenStream(ind);
        this.seekStreamIfNecessary(stream, 0L);
        while (buf.hasRemaining()) {
            int read = stream.read(buf);
            if (read == -1) {
                if (buf.hasRemaining()) {
                    LOG.trace("{}: unexpected EOF with {} bytes remaining [{}]", new Object[]{this, buf.remaining(), ind});
                    throw new IOException("Expected to read " + buf.remaining() + " bytes from block " + this.getBlockID() + " EC index " + (ind + 1) + " but reached EOF");
                }
                LOG.debug("{}: EOF for [{}]", (Object)this, (Object)ind);
                break;
            }
            LOG.trace("{}: read {} bytes for [{}]", new Object[]{this, read, ind});
        }
    }

    private void decodeStripe() throws IOException {
        int[] erasedIndexes = this.missingIndexes.stream().mapToInt(Integer::valueOf).toArray();
        this.decoder.decode(this.decoderInputBuffers, erasedIndexes, this.decoderOutputBuffers);
        this.flipInputs();
    }

    @Override
    public synchronized boolean hasSufficientLocations() {
        if (this.decoderInputBuffers == null) {
            this.decoderInputBuffers = new ByteBuffer[this.getRepConfig().getRequiredNodes()];
        }
        this.markMissingLocationsAsFailed();
        this.selectIndexes();
        return this.selectedIndexes.size() >= this.dataIndexes.size();
    }

    @Override
    protected int readWithStrategy(ByteReaderStrategy strategy) {
        throw new NotImplementedException("readWithStrategy is not implemented. Use readStripe() instead");
    }

    @Override
    public synchronized void close() {
        super.close();
        this.freeBuffers();
    }

    @Override
    public synchronized void unbuffer() {
        super.unbuffer();
        this.freeBuffers();
    }

    private void freeBuffers() {
        if (this.decoderInputBuffers != null) {
            for (int i : new ArrayList<Integer>(this.internalBuffers)) {
                this.releaseInternalBuffer(i);
            }
            this.internalBuffers.clear();
        }
        this.initialized = false;
    }

    private void freeAllResourcesWithoutClosing() throws IOException {
        LOG.debug("{}: Freeing all resources while leaving the block open", (Object)this);
        this.freeBuffers();
        this.closeStreams();
    }

    @Override
    public synchronized void seek(long pos) throws IOException {
        if (pos % this.getStripeSize() != 0L) {
            throw new IOException("Requested position " + pos + " does not align with a stripe offset");
        }
        super.seek(pos);
    }

    private void selectIndexes() {
        int required;
        TreeSet<Integer> candidates;
        this.missingIndexes.clear();
        this.selectedIndexes.clear();
        if (this.isOfflineRecovery()) {
            if (!this.paddingIndexes.isEmpty()) {
                this.paddingIndexes.forEach(i -> Preconditions.assertTrue(!this.recoveryIndexes.contains(i), () -> "Padding index " + i + " should not be selected for recovery"));
            }
            this.missingIndexes.addAll(this.recoveryIndexes);
            TreeSet<Integer> availableIndexes = new TreeSet<Integer>();
            availableIndexes.addAll(this.dataIndexes);
            availableIndexes.addAll(this.parityIndexes);
            availableIndexes.removeAll(this.failedDataIndexes);
            availableIndexes.removeAll(this.recoveryIndexes);
            candidates = availableIndexes;
            required = this.dataIndexes.size();
        } else {
            this.missingIndexes.addAll(this.failedDataIndexes);
            this.missingIndexes.retainAll(this.dataIndexes);
            TreeSet<Integer> dataAvailable = new TreeSet<Integer>(this.dataIndexes);
            dataAvailable.removeAll(this.failedDataIndexes);
            TreeSet<Integer> parityAvailable = new TreeSet<Integer>(this.parityIndexes);
            parityAvailable.removeAll(this.failedDataIndexes);
            this.selectedIndexes.addAll(dataAvailable);
            candidates = parityAvailable;
            required = this.dataIndexes.size() - dataAvailable.size();
        }
        SortedSet<Integer> internal = this.selectInternalInputs(candidates, required);
        LOG.debug("{}: selected {}, {} as inputs", new Object[]{this, this.selectedIndexes, internal});
        this.selectedIndexes.addAll(internal);
    }

    private static SortedSet<Integer> setOfRange(int startInclusive, int endExclusive) {
        return IntStream.range(startInclusive, endExclusive).boxed().collect(Collectors.toCollection(TreeSet::new));
    }
}

