/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.ConfigTag;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.DelegatingProperties;
import org.apache.hadoop.hdds.conf.MutableConfigurationSource;

public class LegacyHadoopConfigurationSource
implements MutableConfigurationSource {
    private Configuration configuration;

    public LegacyHadoopConfigurationSource(Configuration configuration) {
        this.configuration = new Configuration(configuration){
            private Properties delegatingProps;

            public synchronized void reloadConfiguration() {
                super.reloadConfiguration();
                this.delegatingProps = null;
            }

            protected synchronized Properties getProps() {
                if (this.delegatingProps == null) {
                    String complianceMode = this.getPropertyUnsafe("ozone.security.crypto.compliance.mode", "unrestricted");
                    Properties cryptoProperties = this.getCryptoProperties();
                    this.delegatingProps = new DelegatingProperties(super.getProps(), complianceMode, cryptoProperties);
                }
                return this.delegatingProps;
            }

            private String getPropertyUnsafe(String key, String defaultValue) {
                return super.getProps().getProperty(key, defaultValue);
            }

            private Properties getCryptoProperties() {
                try {
                    return super.getAllPropertiesByTag(ConfigTag.CRYPTO_COMPLIANCE.toString());
                }
                catch (NoSuchMethodError e) {
                    return new Properties();
                }
            }

            public Iterator<Map.Entry<String, String>> iterator() {
                DelegatingProperties props = (DelegatingProperties)this.getProps();
                return props.iterator();
            }
        };
    }

    @Override
    public String get(String key) {
        return this.configuration.getRaw(key);
    }

    @Override
    public char[] getPassword(String key) throws IOException {
        return this.configuration.getPassword(key);
    }

    @Override
    public Collection<String> getConfigKeys() {
        return this.configuration.getPropsWithPrefix("").keySet();
    }

    @Override
    public void set(String key, String value) {
        this.configuration.set(key, value);
    }

    public static Configuration asHadoopConfiguration(ConfigurationSource config) {
        if (config instanceof Configuration) {
            return (Configuration)config;
        }
        if (config instanceof LegacyHadoopConfigurationSource) {
            return ((LegacyHadoopConfigurationSource)config).configuration;
        }
        throw new IllegalArgumentException("Core Hadoop code requires real Hadoop configuration");
    }

    public Configuration getOriginalHadoopConfiguration() {
        return this.configuration;
    }
}

