/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.tracing;

import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.grpc.CallOptions;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.grpc.Channel;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.grpc.ClientCall;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.grpc.ClientInterceptor;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.grpc.ForwardingClientCall;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.grpc.Metadata;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.grpc.MethodDescriptor;

public class GrpcClientInterceptor
implements ClientInterceptor {
    public static final Metadata.Key<String> TRACING_HEADER = Metadata.Key.of("Tracing", Metadata.ASCII_STRING_MARSHALLER);

    @Override
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            @Override
            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                Metadata tracingHeaders = new Metadata();
                tracingHeaders.put(TRACING_HEADER, TracingUtil.exportCurrentSpan());
                headers.merge(tracingHeaders);
                super.start(responseListener, headers);
            }
        };
    }
}

