/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.server;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import org.apache.ozone.shaded.org.apache.ratis.util.AtomicFileOutputStream;
import org.apache.ozone.shaded.org.yaml.snakeyaml.LoaderOptions;
import org.apache.ozone.shaded.org.yaml.snakeyaml.Yaml;
import org.apache.ozone.shaded.org.yaml.snakeyaml.inspector.TagInspector;
import org.slf4j.Logger;

public final class YamlUtils {
    private static final Yaml LOADER = YamlUtils.getYamlForLoad();

    private YamlUtils() {
    }

    public static <T> T loadAs(InputStream input, Class<? super T> type) {
        return LOADER.loadAs(input, type);
    }

    private static Yaml getYamlForLoad() {
        TagInspector tags = tag -> tag.getClassName().startsWith("org.apache.hadoop.hdds.") || tag.getClassName().startsWith("org.apache.hadoop.ozone.");
        LoaderOptions loaderOptions = new LoaderOptions();
        loaderOptions.setTagInspector(tags);
        return new Yaml(loaderOptions);
    }

    public static void dump(Yaml yaml, Object data, File file, Logger log) throws IOException {
        try (AtomicFileOutputStream out = new AtomicFileOutputStream(file);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);){
            yaml.dump(data, writer);
        }
        catch (IOException e) {
            log.warn("Failed to dump {}", data, (Object)e);
            throw e;
        }
    }
}

