/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.ozone;

import java.io.OutputStream;
import org.apache.hadoop.crypto.CryptoOutputStream;
import org.apache.hadoop.fs.StreamCapabilities;
import org.apache.hadoop.fs.impl.StoreImplementationUtils;
import org.apache.hadoop.fs.ozone.OzoneFSOutputStream;
import org.apache.hadoop.ozone.client.io.ECKeyOutputStream;
import org.apache.hadoop.ozone.client.io.KeyOutputStream;
import org.apache.hadoop.util.StringUtils;

public class CapableOzoneFSOutputStream
extends OzoneFSOutputStream
implements StreamCapabilities {
    private final boolean isHsyncEnabled;

    public CapableOzoneFSOutputStream(OzoneFSOutputStream outputStream2, boolean enabled) {
        super(outputStream2.getWrappedOutputStream());
        this.isHsyncEnabled = enabled;
    }

    public boolean hasCapability(String capability) {
        OutputStream os = this.getWrappedOutputStream().getOutputStream();
        if (os instanceof CryptoOutputStream) {
            OutputStream wrapped = ((CryptoOutputStream)os).getWrappedStream();
            return this.hasWrappedCapability(wrapped, capability);
        }
        return this.hasWrappedCapability(os, capability);
    }

    private boolean hasWrappedCapability(OutputStream os, String capability) {
        if (os instanceof ECKeyOutputStream) {
            return false;
        }
        if (os instanceof KeyOutputStream) {
            switch (StringUtils.toLowerCase((String)capability)) {
                case "hflush": 
                case "hsync": {
                    return this.isHsyncEnabled;
                }
            }
            return false;
        }
        return StoreImplementationUtils.hasCapability((OutputStream)os, (String)capability);
    }
}

