/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import org.apache.hadoop.crypto.CipherSuite;
import org.apache.hadoop.crypto.CryptoProtocolVersion;

public class BucketEncryptionKeyInfo {
    private final CryptoProtocolVersion version;
    private final CipherSuite suite;
    private final String keyName;

    public BucketEncryptionKeyInfo(CryptoProtocolVersion version, CipherSuite suite, String keyName) {
        this.version = version;
        this.suite = suite;
        this.keyName = keyName;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public CipherSuite getSuite() {
        return this.suite;
    }

    public CryptoProtocolVersion getVersion() {
        return this.version;
    }

    public BucketEncryptionKeyInfo copy() {
        return new BucketEncryptionKeyInfo(this.version, this.suite, this.keyName);
    }

    public static class Builder {
        private CryptoProtocolVersion version;
        private CipherSuite suite;
        private String keyName;

        public Builder setKeyName(String name) {
            this.keyName = name;
            return this;
        }

        public Builder setSuite(CipherSuite cs) {
            this.suite = cs;
            return this;
        }

        public Builder setVersion(CryptoProtocolVersion ver) {
            this.version = ver;
            return this;
        }

        public BucketEncryptionKeyInfo build() {
            return new BucketEncryptionKeyInfo(this.version, this.suite, this.keyName);
        }
    }
}

