/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.service;

import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.protobuf.ServiceException;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.server.JsonUtils;
import org.apache.hadoop.hdds.utils.db.DBCheckpoint;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OmMetadataManagerImpl;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerRatisUtils;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.util.Time;
import org.apache.ratis.protocol.ClientId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuotaRepairTask {
    private static final Logger LOG = LoggerFactory.getLogger(QuotaRepairTask.class);
    private static final int BATCH_SIZE = 5000;
    private static final int TASK_THREAD_CNT = 3;
    private static final AtomicBoolean IN_PROGRESS = new AtomicBoolean(false);
    private static final RepairStatus REPAIR_STATUS = new RepairStatus();
    private static final AtomicLong RUN_CNT = new AtomicLong(0L);
    private final OzoneManager om;
    private ExecutorService executor;

    public QuotaRepairTask(OzoneManager ozoneManager) {
        this.om = ozoneManager;
    }

    public CompletableFuture<Boolean> repair() throws IOException {
        return this.repair(Collections.emptyList());
    }

    public CompletableFuture<Boolean> repair(List<String> buckets) throws IOException {
        if (!IN_PROGRESS.compareAndSet(false, true)) {
            LOG.info("quota repair task already running");
            throw new OMException("Quota repair is already running", OMException.ResultCodes.QUOTA_ERROR);
        }
        REPAIR_STATUS.reset(RUN_CNT.get() + 1L);
        return CompletableFuture.supplyAsync(() -> this.repairTask(buckets));
    }

    public static String getStatus() {
        return REPAIR_STATUS.toString();
    }

    private boolean repairTask(List<String> buckets) {
        block15: {
            LOG.info("Starting quota repair task {}", (Object)REPAIR_STATUS);
            OMMetadataManager activeMetaManager = null;
            try {
                this.executor = Executors.newFixedThreadPool(12);
                OzoneManagerProtocolProtos.QuotaRepairRequest.Builder builder = OzoneManagerProtocolProtos.QuotaRepairRequest.newBuilder();
                activeMetaManager = this.createActiveDBCheckpoint(this.om.getMetadataManager(), this.om.getConfiguration());
                this.repairActiveDb(activeMetaManager, builder, buckets);
                ClientId clientId = ClientId.randomId();
                OzoneManagerProtocolProtos.OMRequest omRequest = OzoneManagerProtocolProtos.OMRequest.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.QuotaRepair).setQuotaRepairRequest(builder.build()).setClientId(clientId.toString()).build();
                OzoneManagerProtocolProtos.OMResponse response = this.submitRequest(omRequest, clientId);
                if (response != null && response.getSuccess()) {
                    REPAIR_STATUS.updateStatus(builder, this.om.getMetadataManager());
                    break block15;
                }
                LOG.error("update quota repair count response failed");
                REPAIR_STATUS.updateStatus("Response for update DB is failed");
                return false;
            }
            catch (Exception exp) {
                LOG.error("quota repair count failed", (Throwable)exp);
                REPAIR_STATUS.updateStatus(exp.toString());
                return false;
            }
            finally {
                LOG.info("Completed quota repair task {}", (Object)REPAIR_STATUS);
                this.executor.shutdown();
                try {
                    if (activeMetaManager != null) {
                        activeMetaManager.stop();
                    }
                    QuotaRepairTask.cleanTempCheckPointPath(this.om.getMetadataManager());
                }
                catch (Exception exp) {
                    LOG.error("failed to cleanup", (Throwable)exp);
                }
                IN_PROGRESS.set(false);
            }
        }
        return true;
    }

    private void repairActiveDb(OMMetadataManager metadataManager, OzoneManagerProtocolProtos.QuotaRepairRequest.Builder builder, List<String> buckets) throws Exception {
        HashMap<String, OmBucketInfo> nameBucketInfoMap = new HashMap<String, OmBucketInfo>();
        HashMap<String, OmBucketInfo> idBucketInfoMap = new HashMap<String, OmBucketInfo>();
        HashMap<String, OmBucketInfo> oriBucketInfoMap = new HashMap<String, OmBucketInfo>();
        this.prepareAllBucketInfo(nameBucketInfoMap, idBucketInfoMap, oriBucketInfoMap, metadataManager, buckets);
        if (nameBucketInfoMap.isEmpty()) {
            throw new OMException("no matching buckets", OMException.ResultCodes.BUCKET_NOT_FOUND);
        }
        this.repairCount(nameBucketInfoMap, idBucketInfoMap, metadataManager);
        for (Map.Entry entry : nameBucketInfoMap.entrySet()) {
            boolean oldQuota;
            OmBucketInfo oriBucketInfo = (OmBucketInfo)oriBucketInfoMap.get(entry.getKey());
            OmBucketInfo updatedBuckedInfo = (OmBucketInfo)entry.getValue();
            boolean bl = oldQuota = oriBucketInfo.getQuotaInBytes() == -2L || oriBucketInfo.getQuotaInNamespace() == -2L;
            if (!oldQuota && !this.isChange(oriBucketInfo, updatedBuckedInfo)) continue;
            OzoneManagerProtocolProtos.BucketQuotaCount.Builder bucketCountBuilder = OzoneManagerProtocolProtos.BucketQuotaCount.newBuilder();
            bucketCountBuilder.setVolName(updatedBuckedInfo.getVolumeName());
            bucketCountBuilder.setBucketName(updatedBuckedInfo.getBucketName());
            bucketCountBuilder.setDiffUsedBytes(updatedBuckedInfo.getUsedBytes() - oriBucketInfo.getUsedBytes());
            bucketCountBuilder.setDiffUsedNamespace(updatedBuckedInfo.getUsedNamespace() - oriBucketInfo.getUsedNamespace());
            bucketCountBuilder.setSupportOldQuota(oldQuota);
            builder.addBucketCount(bucketCountBuilder.build());
        }
        if (buckets.isEmpty()) {
            builder.setSupportVolumeOldQuota(true);
        } else {
            builder.setSupportVolumeOldQuota(false);
        }
    }

    private OzoneManagerProtocolProtos.OMResponse submitRequest(OzoneManagerProtocolProtos.OMRequest omRequest, ClientId clientId) throws Exception {
        try {
            return OzoneManagerRatisUtils.submitRequest(this.om, omRequest, clientId, RUN_CNT.getAndIncrement());
        }
        catch (ServiceException e) {
            LOG.error("repair quota count " + omRequest.getCmdType() + " request failed.", (Throwable)e);
            throw e;
        }
    }

    private OMMetadataManager createActiveDBCheckpoint(OMMetadataManager omMetaManager, OzoneConfiguration conf) throws IOException {
        String parentPath = QuotaRepairTask.cleanTempCheckPointPath(omMetaManager);
        DBCheckpoint checkpoint = omMetaManager.getStore().getCheckpoint(parentPath, true);
        return OmMetadataManagerImpl.createCheckpointMetadataManager(conf, checkpoint);
    }

    private static String cleanTempCheckPointPath(OMMetadataManager omMetaManager) throws IOException {
        File dbLocation = omMetaManager.getStore().getDbLocation();
        if (dbLocation == null) {
            throw new NullPointerException("db location is null");
        }
        String tempData = dbLocation.getParent();
        if (tempData == null) {
            throw new NullPointerException("parent db dir is null");
        }
        File repairTmpPath = Paths.get(tempData, "temp-repair-quota").toFile();
        FileUtils.deleteDirectory((File)repairTmpPath);
        FileUtils.forceMkdir((File)repairTmpPath);
        return repairTmpPath.toString();
    }

    private void prepareAllBucketInfo(Map<String, OmBucketInfo> nameBucketInfoMap, Map<String, OmBucketInfo> idBucketInfoMap, Map<String, OmBucketInfo> oriBucketInfoMap, OMMetadataManager metadataManager, List<String> buckets) throws IOException {
        if (!buckets.isEmpty()) {
            for (String bucketkey : buckets) {
                OmBucketInfo bucketInfo = (OmBucketInfo)metadataManager.getBucketTable().get((Object)bucketkey);
                if (bucketInfo == null) continue;
                QuotaRepairTask.populateBucket(nameBucketInfoMap, idBucketInfoMap, oriBucketInfoMap, metadataManager, bucketInfo);
            }
            return;
        }
        Throwable throwable = null;
        Object var7_7 = null;
        try (TableIterator iterator = metadataManager.getBucketTable().valueIterator();){
            while (iterator.hasNext()) {
                OmBucketInfo bucketInfo = (OmBucketInfo)iterator.next();
                QuotaRepairTask.populateBucket(nameBucketInfoMap, idBucketInfoMap, oriBucketInfoMap, metadataManager, bucketInfo);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void populateBucket(Map<String, OmBucketInfo> nameBucketInfoMap, Map<String, OmBucketInfo> idBucketInfoMap, Map<String, OmBucketInfo> oriBucketInfoMap, OMMetadataManager metadataManager, OmBucketInfo bucketInfo) throws IOException {
        String bucketNameKey = QuotaRepairTask.buildNamePath(bucketInfo.getVolumeName(), bucketInfo.getBucketName());
        oriBucketInfoMap.put(bucketNameKey, bucketInfo.copyObject());
        bucketInfo.decrUsedBytes(bucketInfo.getUsedBytes(), false);
        bucketInfo.decrUsedNamespace(bucketInfo.getUsedNamespace(), false);
        nameBucketInfoMap.put(bucketNameKey, bucketInfo);
        idBucketInfoMap.put(QuotaRepairTask.buildIdPath(metadataManager.getVolumeId(bucketInfo.getVolumeName()), bucketInfo.getObjectID()), bucketInfo);
    }

    private boolean isChange(OmBucketInfo lBucketInfo, OmBucketInfo rBucketInfo) {
        return lBucketInfo.getUsedNamespace() != rBucketInfo.getUsedNamespace() || lBucketInfo.getUsedBytes() != rBucketInfo.getUsedBytes();
    }

    private static String buildNamePath(String volumeName, String bucketName) {
        StringBuilder builder = new StringBuilder();
        builder.append("/").append(volumeName).append("/").append(bucketName).append("/");
        return builder.toString();
    }

    private static String buildIdPath(long volumeId, long bucketId) {
        StringBuilder builder = new StringBuilder();
        builder.append("/").append(volumeId).append("/").append(bucketId).append("/");
        return builder.toString();
    }

    private void repairCount(Map<String, OmBucketInfo> nameBucketInfoMap, Map<String, OmBucketInfo> idBucketInfoMap, OMMetadataManager metadataManager) throws Exception {
        LOG.info("Starting quota repair counting for all keys, files and directories");
        ConcurrentHashMap<String, CountPair> keyCountMap = new ConcurrentHashMap<String, CountPair>();
        ConcurrentHashMap<String, CountPair> fileCountMap = new ConcurrentHashMap<String, CountPair>();
        ConcurrentHashMap<String, CountPair> directoryCountMap = new ConcurrentHashMap<String, CountPair>();
        try {
            nameBucketInfoMap.keySet().stream().forEach(e -> {
                CountPair countPair = keyCountMap.put((String)e, new CountPair());
            });
            idBucketInfoMap.keySet().stream().forEach(e -> {
                CountPair countPair = fileCountMap.put((String)e, new CountPair());
            });
            idBucketInfoMap.keySet().stream().forEach(e -> {
                CountPair countPair = directoryCountMap.put((String)e, new CountPair());
            });
            ArrayList tasks = new ArrayList();
            tasks.add(this.executor.submit(() -> this.recalculateUsages(metadataManager.getKeyTable(BucketLayout.OBJECT_STORE), keyCountMap, "Key usages", true)));
            tasks.add(this.executor.submit(() -> this.recalculateUsages(metadataManager.getKeyTable(BucketLayout.FILE_SYSTEM_OPTIMIZED), fileCountMap, "File usages", true)));
            tasks.add(this.executor.submit(() -> this.recalculateUsages(metadataManager.getDirectoryTable(), directoryCountMap, "Directory usages", false)));
            for (Future future : tasks) {
                future.get();
            }
        }
        catch (UncheckedIOException ex) {
            LOG.error("quota repair failure", (Throwable)ex.getCause());
            throw ex.getCause();
        }
        catch (UncheckedExecutionException ex) {
            LOG.error("quota repair failure", ex.getCause());
            throw new Exception(ex.getCause());
        }
        QuotaRepairTask.updateCountToBucketInfo(nameBucketInfoMap, keyCountMap);
        QuotaRepairTask.updateCountToBucketInfo(idBucketInfoMap, fileCountMap);
        QuotaRepairTask.updateCountToBucketInfo(idBucketInfoMap, directoryCountMap);
        LOG.info("Completed quota repair counting for all keys, files and directories");
    }

    private <VALUE> void recalculateUsages(Table<String, VALUE> table, Map<String, CountPair> prefixUsageMap, String strType, boolean haveValue) throws UncheckedIOException, UncheckedExecutionException {
        LOG.info("Starting recalculate {}", (Object)strType);
        ArrayList<Table.KeyValue> kvList = new ArrayList<Table.KeyValue>(5000);
        ArrayBlockingQueue<ArrayList<Table.KeyValue>> q = new ArrayBlockingQueue<ArrayList<Table.KeyValue>>(3);
        ArrayList tasks = new ArrayList();
        AtomicBoolean isRunning = new AtomicBoolean(true);
        int i = 0;
        while (i < 3) {
            tasks.add(this.executor.submit(() -> QuotaRepairTask.captureCount(prefixUsageMap, q, isRunning, haveValue)));
            ++i;
        }
        int count = 0;
        long startTime = Time.monotonicNow();
        try {
            Throwable throwable = null;
            Object var13_15 = null;
            try (Table.KeyValueIterator keyIter = table.iterator(null, haveValue ? Table.KeyValueIterator.Type.KEY_AND_VALUE : Table.KeyValueIterator.Type.KEY_ONLY);){
                while (keyIter.hasNext()) {
                    ++count;
                    kvList.add((Table.KeyValue)keyIter.next());
                    if (kvList.size() != 5000) continue;
                    q.put(kvList);
                    kvList = new ArrayList(5000);
                }
                q.put(kvList);
                isRunning.set(false);
                for (Future future : tasks) {
                    future.get();
                }
                LOG.info("Recalculate {} completed, count {} time {}ms", new Object[]{strType, count, Time.monotonicNow() - startTime});
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException ex) {
            throw new UncheckedExecutionException((Throwable)ex);
        }
    }

    private static <VALUE> void captureCount(Map<String, CountPair> prefixUsageMap, BlockingQueue<List<Table.KeyValue<String, VALUE>>> q, AtomicBoolean isRunning, boolean haveValue) throws UncheckedIOException {
        try {
            while (isRunning.get() || !q.isEmpty()) {
                List<Table.KeyValue<String, VALUE>> kvList = q.poll(100L, TimeUnit.MILLISECONDS);
                if (kvList == null) continue;
                for (Table.KeyValue<String, VALUE> kv : kvList) {
                    QuotaRepairTask.extractCount(kv, prefixUsageMap, haveValue);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    private static <VALUE> void extractCount(Table.KeyValue<String, VALUE> kv, Map<String, CountPair> prefixUsageMap, boolean haveValue) {
        Object value;
        String prefix = QuotaRepairTask.getVolumeBucketPrefix((String)kv.getKey());
        CountPair usage = prefixUsageMap.get(prefix);
        if (usage == null) {
            return;
        }
        usage.incrNamespace(1L);
        if (haveValue && (value = kv.getValue()) instanceof OmKeyInfo) {
            usage.incrSpace(((OmKeyInfo)value).getReplicatedSize());
        }
    }

    private static synchronized void updateCountToBucketInfo(Map<String, OmBucketInfo> bucketInfoMap, Map<String, CountPair> prefixUsageMap) {
        for (Map.Entry<String, CountPair> entry : prefixUsageMap.entrySet()) {
            OmBucketInfo omBucketInfo = bucketInfoMap.get(entry.getKey());
            if (omBucketInfo == null) continue;
            omBucketInfo.incrUsedBytes(entry.getValue().getSpace());
            omBucketInfo.incrUsedNamespace(entry.getValue().getNamespace());
        }
    }

    private static String getVolumeBucketPrefix(String key) {
        String prefix = key;
        int idx = key.indexOf("/", 1);
        if (idx != -1 && (idx = key.indexOf("/", idx + 1)) != -1) {
            prefix = key.substring(0, idx + 1);
        }
        return prefix;
    }

    private static class CountPair {
        private AtomicLong space = new AtomicLong();
        private AtomicLong namespace = new AtomicLong();

        private CountPair() {
        }

        public void incrSpace(long val) {
            this.space.getAndAdd(val);
        }

        public void incrNamespace(long val) {
            this.namespace.getAndAdd(val);
        }

        public long getSpace() {
            return this.space.get();
        }

        public long getNamespace() {
            return this.namespace.get();
        }
    }

    public static class RepairStatus {
        private boolean isTriggered = false;
        private long taskId = 0L;
        private long lastRunStartTime = 0L;
        private long lastRunFinishedTime = 0L;
        private String errorMsg = null;
        private Map<String, Map<String, Long>> bucketCountDiffMap = new ConcurrentHashMap<String, Map<String, Long>>();

        public String toString() {
            if (!this.isTriggered) {
                return "{}";
            }
            HashMap<String, Object> status = new HashMap<String, Object>();
            status.put("taskId", this.taskId);
            status.put("lastRunStartTime", this.lastRunStartTime > 0L ? new Date(this.lastRunStartTime).toString() : "");
            status.put("lastRunFinishedTime", this.lastRunFinishedTime > 0L ? new Date(this.lastRunFinishedTime).toString() : "");
            status.put("errorMsg", this.errorMsg);
            status.put("bucketCountDiffMap", this.bucketCountDiffMap);
            try {
                return JsonUtils.toJsonString(status);
            }
            catch (IOException e) {
                LOG.error("error in generating status", (Throwable)e);
                return "{}";
            }
        }

        public void updateStatus(OzoneManagerProtocolProtos.QuotaRepairRequest.Builder builder, OMMetadataManager metadataManager) {
            this.isTriggered = true;
            this.lastRunFinishedTime = System.currentTimeMillis();
            this.errorMsg = "";
            this.bucketCountDiffMap.clear();
            for (OzoneManagerProtocolProtos.BucketQuotaCount quotaCount : builder.getBucketCountList()) {
                String bucketKey = metadataManager.getBucketKey(quotaCount.getVolName(), quotaCount.getBucketName());
                ConcurrentHashMap<String, Long> diffCountMap = new ConcurrentHashMap<String, Long>();
                diffCountMap.put("DiffUsedBytes", quotaCount.getDiffUsedBytes());
                diffCountMap.put("DiffUsedNamespace", quotaCount.getDiffUsedNamespace());
                this.bucketCountDiffMap.put(bucketKey, diffCountMap);
            }
        }

        public void updateStatus(String errMsg) {
            this.isTriggered = true;
            this.lastRunFinishedTime = System.currentTimeMillis();
            this.errorMsg = errMsg;
            this.bucketCountDiffMap.clear();
        }

        public void reset(long tskId) {
            this.isTriggered = true;
            this.taskId = tskId;
            this.lastRunStartTime = System.currentTimeMillis();
            this.lastRunFinishedTime = 0L;
            this.errorMsg = "";
            this.bucketCountDiffMap.clear();
        }
    }
}

