/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.OzoneManagerVersion;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.KeyValueUtil;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OzoneFSUtils;
import org.apache.hadoop.ozone.om.helpers.QuotaUtil;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.WithMetadata;
import org.apache.hadoop.ozone.om.lock.IOzoneManagerLock;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.request.util.OmKeyHSyncUtil;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.request.validation.RequestFeatureValidator;
import org.apache.hadoop.ozone.om.request.validation.ValidationCondition;
import org.apache.hadoop.ozone.om.request.validation.ValidationContext;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.OMKeyCommitResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeature;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.request.validation.RequestProcessingPhase;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.upgrade.LayoutFeature;
import org.apache.hadoop.util.Time;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMKeyCommitRequest
extends OMKeyRequest {
    @VisibleForTesting
    private static final Logger LOG;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        OMKeyCommitRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(OMKeyCommitRequest.class);
    }

    public OMKeyCommitRequest(OzoneManagerProtocolProtos.OMRequest omRequest, BucketLayout bucketLayout) {
        super(omRequest, bucketLayout);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2));
        }
        OzoneManagerProtocolProtos.OMRequest request = super.preExecute(ozoneManager);
        OzoneManagerProtocolProtos.CommitKeyRequest commitKeyRequest = request.getCommitKeyRequest();
        Preconditions.checkNotNull((Object)commitKeyRequest);
        OzoneManagerProtocolProtos.KeyArgs keyArgs = commitKeyRequest.getKeyArgs();
        if (keyArgs.hasExpectedDataGeneration()) {
            ozoneManager.checkFeatureEnabled(OzoneManagerVersion.ATOMIC_REWRITE_KEY);
        }
        if (ozoneManager.getConfig().isKeyNameCharacterCheckEnabled()) {
            OmUtils.validateKeyName((String)keyArgs.getKeyName());
        }
        boolean isHsync = commitKeyRequest.hasHsync() && commitKeyRequest.getHsync();
        boolean isRecovery = commitKeyRequest.hasRecovery() && commitKeyRequest.getRecovery();
        boolean enableHsync = OzoneFSUtils.canEnableHsync((ConfigurationSource)ozoneManager.getConfiguration(), (boolean)false);
        if ((isHsync || isRecovery) && !enableHsync) {
            throw new OMException("Hsync is not enabled. To enable, set ozone.fs.hsync.enabled = true", OMException.ResultCodes.NOT_SUPPORTED_OPERATION);
        }
        String keyPath = keyArgs.getKeyName();
        keyPath = OMKeyCommitRequest.validateAndNormalizeKey(ozoneManager.getEnableFileSystemPaths(), keyPath, this.getBucketLayout());
        OzoneManagerProtocolProtos.KeyArgs.Builder newKeyArgs = keyArgs.toBuilder().setModificationTime(Time.now()).setKeyName(keyPath);
        OzoneManagerProtocolProtos.KeyArgs resolvedKeyArgs = this.resolveBucketAndCheckOpenKeyAcls(newKeyArgs.build(), ozoneManager, IAccessAuthorizer.ACLType.WRITE, commitKeyRequest.getClientID());
        return request.toBuilder().setCommitKeyRequest(commitKeyRequest.toBuilder().setKeyArgs(resolvedKeyArgs)).build();
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, ExecutionContext context) {
        OMClientRequest.Result result;
        boolean isRecovery;
        boolean isHSync;
        OMClientResponse omClientResponse;
        OmKeyInfo omKeyInfo;
        Exception exception;
        Map<String, String> auditMap;
        AuditLogger auditLogger;
        OMMetrics omMetrics;
        String keyName;
        String bucketName;
        String volumeName;
        OzoneManagerProtocolProtos.CommitKeyRequest commitKeyRequest;
        block37: {
            long trxnLogIndex = context.getIndex();
            commitKeyRequest = this.getOmRequest().getCommitKeyRequest();
            OzoneManagerProtocolProtos.KeyArgs commitKeyArgs = commitKeyRequest.getKeyArgs();
            volumeName = commitKeyArgs.getVolumeName();
            bucketName = commitKeyArgs.getBucketName();
            keyName = commitKeyArgs.getKeyName();
            omMetrics = ozoneManager.getMetrics();
            auditLogger = ozoneManager.getAuditLogger();
            auditMap = this.buildKeyArgsAuditMap(commitKeyArgs);
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            exception = null;
            omKeyInfo = null;
            OmBucketInfo omBucketInfo = null;
            omClientResponse = null;
            boolean bucketLockAcquired = false;
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            isHSync = commitKeyRequest.hasHsync() && commitKeyRequest.getHsync();
            boolean bl = isRecovery = commitKeyRequest.hasRecovery() && commitKeyRequest.getRecovery();
            if (isHSync) {
                omMetrics.incNumKeyHSyncs();
            } else {
                omMetrics.incNumKeyCommits();
            }
            LOG.debug("isHSync = {}, isRecovery = {}, volumeName = {}, bucketName = {}, keyName = {}", new Object[]{isHSync, isRecovery, volumeName, bucketName, keyName});
            try {
                try {
                    String dbOzoneKey = omMetadataManager.getOzoneKey(volumeName, bucketName, keyName);
                    List<OmKeyLocationInfo> locationInfoList = this.getOmKeyLocationInfos(ozoneManager, commitKeyArgs);
                    this.mergeOmLockDetails(omMetadataManager.getLock().acquireWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                    bucketLockAcquired = this.getOmLockDetails().isLockAcquired();
                    this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
                    omBucketInfo = OMKeyCommitRequest.getBucketInfo(omMetadataManager, volumeName, bucketName);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("BucketName: {}, BucketLayout: {}", (Object)omBucketInfo.getBucketName(), (Object)omBucketInfo.getBucketLayout());
                    }
                    if (omBucketInfo.getBucketLayout().shouldNormalizePaths(ozoneManager.getEnableFileSystemPaths())) {
                        if (this.checkDirectoryAlreadyExists(volumeName, bucketName, keyName, omMetadataManager)) {
                            throw new OMException("Can not create file: " + keyName + " as there is already directory in the given path", OMException.ResultCodes.NOT_A_FILE);
                        }
                        if (!"".equals(OzoneFSUtils.getParent((String)keyName)) && !this.checkDirectoryAlreadyExists(volumeName, bucketName, OzoneFSUtils.getParent((String)keyName), omMetadataManager)) {
                            throw new OMException("Cannot create file : " + keyName + " as parent directory doesn't exist", OMException.ResultCodes.DIRECTORY_NOT_FOUND);
                        }
                    }
                    OmKeyInfo keyToDelete = (OmKeyInfo)omMetadataManager.getKeyTable(this.getBucketLayout()).get((Object)dbOzoneKey);
                    long writerClientId = commitKeyRequest.getClientID();
                    boolean isSameHsyncKey = false;
                    boolean isOverwrittenHsyncKey = false;
                    String clientIdString = String.valueOf(writerClientId);
                    if (keyToDelete != null && !(isSameHsyncKey = Optional.of(keyToDelete).map(WithMetadata::getMetadata).map(meta -> (String)meta.get("hsyncClientId")).filter(id -> id.equals(clientIdString)).isPresent())) {
                        boolean bl2 = isOverwrittenHsyncKey = Optional.of(keyToDelete).map(WithMetadata::getMetadata).map(meta -> (String)meta.get("hsyncClientId")).filter(id -> !id.equals(clientIdString)).isPresent() && !isRecovery;
                    }
                    if (isRecovery && keyToDelete != null) {
                        String clientId = (String)keyToDelete.getMetadata().get("hsyncClientId");
                        if (clientId == null) {
                            throw new OMException("Failed to recovery key, as " + dbOzoneKey + " is already closed", OMException.ResultCodes.KEY_ALREADY_CLOSED);
                        }
                        writerClientId = Long.parseLong(clientId);
                    }
                    String dbOpenKey = omMetadataManager.getOpenKey(volumeName, bucketName, keyName, writerClientId);
                    omKeyInfo = (OmKeyInfo)omMetadataManager.getOpenKeyTable(this.getBucketLayout()).get((Object)dbOpenKey);
                    if (omKeyInfo == null) {
                        String action = isRecovery ? "recovery" : (isHSync ? "hsync" : "commit");
                        throw new OMException("Failed to " + action + " key, as " + dbOpenKey + " entry is not found in the OpenKey table", OMException.ResultCodes.KEY_NOT_FOUND);
                    }
                    if (omKeyInfo.getMetadata().containsKey("deletedHsyncKey") || omKeyInfo.getMetadata().containsKey("overwrittenHsyncKey")) {
                        throw new OMException("Open Key " + keyName + " is already deleted/overwritten", OMException.ResultCodes.KEY_NOT_FOUND);
                    }
                    if (omKeyInfo.getMetadata().containsKey("leaseRecovery") && omKeyInfo.getMetadata().containsKey("hsyncClientId") && !isRecovery) {
                        throw new OMException("Cannot commit key " + dbOpenKey + " with " + "leaseRecovery" + " metadata while recovery flag is not set in request", OMException.ResultCodes.KEY_UNDER_LEASE_RECOVERY);
                    }
                    OmKeyInfo openKeyToDelete = null;
                    String dbOpenKeyToDeleteKey = null;
                    if (isOverwrittenHsyncKey) {
                        dbOpenKeyToDeleteKey = omMetadataManager.getOpenKey(volumeName, bucketName, keyName, Long.parseLong((String)keyToDelete.getMetadata().get("hsyncClientId")));
                        openKeyToDelete = (OmKeyInfo)omMetadataManager.getOpenKeyTable(this.getBucketLayout()).get((Object)dbOpenKeyToDeleteKey);
                        openKeyToDelete.getMetadata().put("overwrittenHsyncKey", "true");
                        openKeyToDelete.setModificationTime(Time.now());
                        openKeyToDelete.setUpdateID(trxnLogIndex);
                        omMetadataManager.getOpenKeyTable(this.getBucketLayout()).addCacheEntry((Object)dbOpenKeyToDeleteKey, (Object)openKeyToDelete, trxnLogIndex);
                    }
                    omKeyInfo.setModificationTime(commitKeyArgs.getModificationTime());
                    OmKeyInfo newOpenKeyInfo = null;
                    if (isHSync && !OmKeyHSyncUtil.isHSyncedPreviously(omKeyInfo, clientIdString, dbOpenKey)) {
                        omKeyInfo.getMetadata().put("hsyncClientId", clientIdString);
                        newOpenKeyInfo = omKeyInfo.copyObject();
                    }
                    this.validateAtomicRewrite(keyToDelete, omKeyInfo, auditMap);
                    omKeyInfo.setExpectedDataGeneration(null);
                    omKeyInfo.getMetadata().putAll(KeyValueUtil.getFromProtobuf((List)commitKeyArgs.getMetadataList()));
                    omKeyInfo.setDataSize(commitKeyArgs.getDataSize());
                    List uncommitted = omKeyInfo.updateLocationInfoList(locationInfoList, false);
                    omKeyInfo.setUpdateID(trxnLogIndex);
                    Map<String, RepeatedOmKeyInfo> oldKeyVersionsToDeleteMap = null;
                    long correctedSpace = omKeyInfo.getReplicatedSize();
                    if (keyToDelete != null && isSameHsyncKey) {
                        this.checkBucketQuotaInBytes(omMetadataManager, omBucketInfo, correctedSpace -= keyToDelete.getReplicatedSize());
                    } else if (keyToDelete != null && !omBucketInfo.getIsVersionEnabled()) {
                        RepeatedOmKeyInfo oldVerKeyInfo = this.getOldVersionsToCleanUp(keyToDelete, omBucketInfo.getObjectID(), trxnLogIndex);
                        long pseudoObjId = ozoneManager.getObjectIdFromTxId(trxnLogIndex);
                        String delKeyName = omMetadataManager.getOzoneDeletePathKey(pseudoObjId, dbOzoneKey);
                        if (oldKeyVersionsToDeleteMap == null) {
                            oldKeyVersionsToDeleteMap = new HashMap<String, RepeatedOmKeyInfo>();
                        }
                        Pair<Map<OmKeyInfo, List<OmKeyLocationInfo>>, Integer> filteredUsedBlockCnt = this.filterOutBlocksStillInUse(omKeyInfo, oldVerKeyInfo);
                        Map blocks = (Map)filteredUsedBlockCnt.getLeft();
                        correctedSpace -= blocks.entrySet().stream().mapToLong(filteredKeyBlocks -> ((List)filteredKeyBlocks.getValue()).stream().mapToLong(block -> QuotaUtil.getReplicatedSize((long)block.getLength(), (ReplicationConfig)((OmKeyInfo)filteredKeyBlocks.getKey()).getReplicationConfig())).sum()).sum();
                        long totalSize = 0L;
                        long totalNamespace = 0L;
                        if (!oldVerKeyInfo.getOmKeyInfoList().isEmpty()) {
                            oldKeyVersionsToDeleteMap.put(delKeyName, oldVerKeyInfo);
                            for (OmKeyInfo olderKeyVersions : oldVerKeyInfo.getOmKeyInfoList()) {
                                olderKeyVersions.setCommittedKeyDeletedFlag(true);
                                totalSize += OMKeyCommitRequest.sumBlockLengths(olderKeyVersions);
                                ++totalNamespace;
                            }
                        }
                        this.checkBucketQuotaInNamespace(omBucketInfo, 1L);
                        this.checkBucketQuotaInBytes(omMetadataManager, omBucketInfo, correctedSpace);
                        omBucketInfo.decrUsedNamespace(totalNamespace, true);
                        omBucketInfo.decrUsedNamespace((long)((Integer)filteredUsedBlockCnt.getRight()).intValue(), false);
                        omBucketInfo.decrUsedBytes(totalSize, true);
                    } else {
                        this.checkBucketQuotaInNamespace(omBucketInfo, 1L);
                        this.checkBucketQuotaInBytes(omMetadataManager, omBucketInfo, correctedSpace);
                    }
                    omBucketInfo.incrUsedNamespace(1L);
                    OmKeyInfo pseudoKeyInfo = isHSync ? null : this.wrapUncommittedBlocksAsPseudoKey(uncommitted, omKeyInfo);
                    oldKeyVersionsToDeleteMap = OMKeyCommitRequest.addKeyInfoToDeleteMap(ozoneManager, trxnLogIndex, dbOzoneKey, omBucketInfo.getObjectID(), pseudoKeyInfo, oldKeyVersionsToDeleteMap);
                    if (!isHSync) {
                        omMetadataManager.getOpenKeyTable(this.getBucketLayout()).addCacheEntry((Object)dbOpenKey, trxnLogIndex);
                        omKeyInfo.getMetadata().remove("hsyncClientId");
                        if (isRecovery) {
                            omKeyInfo.getMetadata().remove("leaseRecovery");
                        }
                    } else if (newOpenKeyInfo != null) {
                        omMetadataManager.getOpenKeyTable(this.getBucketLayout()).addCacheEntry((Object)dbOpenKey, (Object)newOpenKeyInfo, trxnLogIndex);
                    }
                    omMetadataManager.getKeyTable(this.getBucketLayout()).addCacheEntry((Object)dbOzoneKey, (Object)omKeyInfo, trxnLogIndex);
                    omBucketInfo.incrUsedBytes(correctedSpace);
                    omClientResponse = new OMKeyCommitResponse(omResponse.build(), omKeyInfo, dbOzoneKey, dbOpenKey, omBucketInfo.copyObject(), oldKeyVersionsToDeleteMap, isHSync, newOpenKeyInfo, dbOpenKeyToDeleteKey, openKeyToDelete);
                    result = OMClientRequest.Result.SUCCESS;
                }
                catch (IOException | InvalidPathException ex) {
                    result = OMClientRequest.Result.FAILURE;
                    exception = ex;
                    omClientResponse = new OMKeyCommitResponse(this.createErrorOMResponse(omResponse, exception), this.getBucketLayout());
                    if (bucketLockAcquired) {
                        this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                    }
                    if (omClientResponse != null) {
                        omClientResponse.setOmLockDetails(this.getOmLockDetails());
                    }
                    break block37;
                }
            }
            catch (Throwable throwable) {
                if (bucketLockAcquired) {
                    this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                }
                if (omClientResponse != null) {
                    omClientResponse.setOmLockDetails(this.getOmLockDetails());
                }
                throw throwable;
            }
            if (bucketLockAcquired) {
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
            }
            if (omClientResponse != null) {
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
        }
        LOG.debug("Key commit {} with isHSync = {}, isRecovery = {}, omKeyInfo = {}", new Object[]{result == OMClientRequest.Result.SUCCESS ? "succeeded" : "failed", isHSync, isRecovery, omKeyInfo});
        if (!isHSync) {
            this.markForAudit(auditLogger, this.buildAuditMessage(OMAction.COMMIT_KEY, auditMap, exception, this.getOmRequest().getUserInfo()));
            this.processResult(commitKeyRequest, volumeName, bucketName, keyName, omMetrics, exception, omKeyInfo, result);
        }
        return omClientResponse;
    }

    @Nonnull
    protected List<OmKeyLocationInfo> getOmKeyLocationInfos(OzoneManager ozoneManager, OzoneManagerProtocolProtos.KeyArgs commitKeyArgs) {
        ArrayList<OmKeyLocationInfo> locationInfoList = new ArrayList<OmKeyLocationInfo>();
        for (OzoneManagerProtocolProtos.KeyLocation keyLocation : commitKeyArgs.getKeyLocationsList()) {
            OmKeyLocationInfo locationInfo = OmKeyLocationInfo.getFromProtobuf((OzoneManagerProtocolProtos.KeyLocation)keyLocation);
            if (ozoneManager.isGrpcBlockTokenEnabled()) {
                locationInfo.setToken(null);
            }
            locationInfoList.add(locationInfo);
        }
        return locationInfoList;
    }

    protected void processResult(OzoneManagerProtocolProtos.CommitKeyRequest commitKeyRequest, String volumeName, String bucketName, String keyName, OMMetrics omMetrics, Exception exception, OmKeyInfo omKeyInfo, OMClientRequest.Result result) {
        switch (result) {
            case SUCCESS: {
                if (omKeyInfo.getKeyLocationVersions().size() == 1) {
                    omMetrics.incNumKeys();
                }
                if (commitKeyRequest.getKeyArgs().hasEcReplicationConfig()) {
                    omMetrics.incEcKeysTotal();
                }
                omMetrics.incDataCommittedBytes(omKeyInfo.getDataSize());
                LOG.debug("Key committed. Volume:{}, Bucket:{}, Key:{}", new Object[]{volumeName, bucketName, keyName});
                break;
            }
            case FAILURE: {
                LOG.error("Key committed failed. Volume:{}, Bucket:{}, Key:{}. Exception:{}", new Object[]{volumeName, bucketName, keyName, exception});
                if (commitKeyRequest.getKeyArgs().hasEcReplicationConfig()) {
                    omMetrics.incEcKeyCreateFailsTotal();
                }
                omMetrics.incNumKeyCommitFails();
                break;
            }
            default: {
                LOG.error("Unrecognized Result for OMKeyCommitRequest: {}", (Object)commitKeyRequest);
            }
        }
    }

    @RequestFeatureValidator(conditions={ValidationCondition.CLUSTER_NEEDS_FINALIZATION}, processingPhase=RequestProcessingPhase.PRE_PROCESS, requestType=OzoneManagerProtocolProtos.Type.CommitKey)
    public static OzoneManagerProtocolProtos.OMRequest disallowCommitKeyWithECReplicationConfig(OzoneManagerProtocolProtos.OMRequest req, ValidationContext ctx) throws OMException {
        if (!ctx.versionManager().isAllowed((LayoutFeature)OMLayoutFeature.ERASURE_CODED_STORAGE_SUPPORT) && req.getCommitKeyRequest().getKeyArgs().hasEcReplicationConfig()) {
            throw new OMException("Cluster does not have the Erasure Coded Storage support feature finalized yet, but the request contains an Erasure Coded replication type. Rejecting the request, please finalize the cluster upgrade and then try again.", OMException.ResultCodes.NOT_SUPPORTED_OPERATION_PRIOR_FINALIZATION);
        }
        return req;
    }

    @RequestFeatureValidator(conditions={ValidationCondition.OLDER_CLIENT_REQUESTS}, processingPhase=RequestProcessingPhase.PRE_PROCESS, requestType=OzoneManagerProtocolProtos.Type.CommitKey)
    public static OzoneManagerProtocolProtos.OMRequest blockCommitKeyWithBucketLayoutFromOldClient(OzoneManagerProtocolProtos.OMRequest req, ValidationContext ctx) throws IOException {
        OzoneManagerProtocolProtos.KeyArgs keyArgs;
        if (req.getCommitKeyRequest().hasKeyArgs() && (keyArgs = req.getCommitKeyRequest().getKeyArgs()).hasVolumeName() && keyArgs.hasBucketName()) {
            BucketLayout bucketLayout = ctx.getBucketLayout(keyArgs.getVolumeName(), keyArgs.getBucketName());
            bucketLayout.validateSupportedOperation();
        }
        return req;
    }

    @RequestFeatureValidator(conditions={ValidationCondition.CLUSTER_NEEDS_FINALIZATION}, processingPhase=RequestProcessingPhase.PRE_PROCESS, requestType=OzoneManagerProtocolProtos.Type.CommitKey)
    public static OzoneManagerProtocolProtos.OMRequest disallowHsync(OzoneManagerProtocolProtos.OMRequest req, ValidationContext ctx) throws OMException {
        if (!ctx.versionManager().isAllowed((LayoutFeature)OMLayoutFeature.HBASE_SUPPORT)) {
            boolean isHSync;
            OzoneManagerProtocolProtos.CommitKeyRequest commitKeyRequest = req.getCommitKeyRequest();
            boolean bl = isHSync = commitKeyRequest.hasHsync() && commitKeyRequest.getHsync();
            if (isHSync) {
                throw new OMException("Cluster does not have the hsync support feature finalized yet, but the request contains an hsync field. Rejecting the request, please finalize the cluster upgrade and then try again.", OMException.ResultCodes.NOT_SUPPORTED_OPERATION_PRIOR_FINALIZATION);
            }
        }
        return req;
    }

    @RequestFeatureValidator(conditions={ValidationCondition.CLUSTER_NEEDS_FINALIZATION}, processingPhase=RequestProcessingPhase.PRE_PROCESS, requestType=OzoneManagerProtocolProtos.Type.CommitKey)
    public static OzoneManagerProtocolProtos.OMRequest disallowRecovery(OzoneManagerProtocolProtos.OMRequest req, ValidationContext ctx) throws OMException {
        if (!ctx.versionManager().isAllowed((LayoutFeature)OMLayoutFeature.HBASE_SUPPORT)) {
            boolean isRecovery;
            OzoneManagerProtocolProtos.CommitKeyRequest commitKeyRequest = req.getCommitKeyRequest();
            boolean bl = isRecovery = commitKeyRequest.hasRecovery() && commitKeyRequest.getRecovery();
            if (isRecovery) {
                throw new OMException("Cluster does not have the HBase support feature finalized yet, but the request contains an recovery field. Rejecting the request, please finalize the cluster upgrade and then try again.", OMException.ResultCodes.NOT_SUPPORTED_OPERATION_PRIOR_FINALIZATION);
            }
        }
        return req;
    }

    protected void validateAtomicRewrite(OmKeyInfo existing, OmKeyInfo toCommit, Map<String, String> auditMap) throws OMException {
        if (toCommit.getExpectedDataGeneration() != null) {
            auditMap.put("rewriteGeneration", String.valueOf(toCommit.getExpectedDataGeneration()));
            if (existing == null) {
                throw new OMException("Atomic rewrite is not allowed for a new key", OMException.ResultCodes.KEY_NOT_FOUND);
            }
            if (!toCommit.getExpectedDataGeneration().equals(existing.getUpdateID())) {
                throw new OMException("Cannot commit as current generation (" + existing.getUpdateID() + ") does not match the expected generation to rewrite (" + toCommit.getExpectedDataGeneration() + ")", OMException.ResultCodes.KEY_NOT_FOUND);
            }
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OMKeyCommitRequest.java", OMKeyCommitRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.key.OMKeyCommitRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 89);
    }
}

