/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.google.common.annotations.VisibleForTesting;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hdds.utils.TransactionInfo;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;

@Metrics(about="Deletion Service Metrics", context="ozone")
public final class DeletingServiceMetrics {
    public static final String METRICS_SOURCE_NAME = DeletingServiceMetrics.class.getSimpleName();
    private MetricsRegistry registry = new MetricsRegistry(METRICS_SOURCE_NAME);
    @Metric(value={"Total no. of deleted directories sent for purge"})
    private MutableGaugeLong numDirsSentForPurge;
    @Metric(value={"Total no. of sub-directories sent for purge"})
    private MutableGaugeLong numSubDirsSentForPurge;
    @Metric(value={"Total no. of sub-files sent for purge"})
    private MutableGaugeLong numSubFilesSentForPurge;
    @Metric(value={"Total no. of keys processed"})
    private MutableGaugeLong numKeysProcessed;
    @Metric(value={"Total no. of deleted keys sent for purge"})
    private MutableGaugeLong numKeysSentForPurge;
    @Metric(value={"Total no. of directories purged"})
    private MutableGaugeLong numDirsPurged;
    @Metric(value={"Total no. of subFiles moved to deletedTable"})
    private MutableGaugeLong numSubFilesMovedToDeletedTable;
    @Metric(value={"Total no. of subDirectories moved to deletedDirTable"})
    private MutableGaugeLong numSubDirsMovedToDeletedDirTable;
    @Metric(value={"Total no. of keys purged"})
    private MutableGaugeLong numKeysPurged;
    @Metric(value={"Total no. of rename entries purged"})
    private MutableGaugeLong numRenameEntriesPurged;
    private static final long METRIC_RESET_INTERVAL = TimeUnit.DAYS.toSeconds(1L);
    @Metric(value={"Last time the metrics were reset"})
    private MutableGaugeLong metricsResetTimeStamp;
    @Metric(value={"No. of reclaimed keys in the last interval"})
    private MutableGaugeLong keysReclaimedInInterval;
    @Metric(value={"Replicated size of reclaimed keys in the last interval (bytes)"})
    private MutableGaugeLong reclaimedSizeInInterval;
    @Metric(value={"Key Deleting Service last run timestamp in ms"})
    private MutableGaugeLong kdsLastRunTimestamp;
    @Metric(value={"Key Deleting Service current run timestamp in ms"})
    private MutableGaugeLong kdsCurRunTimestamp;
    @Metric(value={"AOS: No. of reclaimed keys in the last run"})
    private MutableGaugeLong aosKeysReclaimedLast;
    @Metric(value={"AOS: Replicated size of reclaimed keys in the last run (bytes)"})
    private MutableGaugeLong aosReclaimedSizeLast;
    @Metric(value={"AOS: No. of iterated keys in the last run"})
    private MutableGaugeLong aosKeysIteratedLast;
    @Metric(value={"AOS: No. of not reclaimable keys the last run"})
    private MutableGaugeLong aosKeysNotReclaimableLast;
    @Metric(value={"Snapshot: No. of reclaimed keys in the last run"})
    private MutableGaugeLong snapKeysReclaimedLast;
    @Metric(value={"Snapshot: Replicated size of reclaimed keys in the last run (bytes)"})
    private MutableGaugeLong snapReclaimedSizeLast;
    @Metric(value={"Snapshot: No. of iterated keys in the last run"})
    private MutableGaugeLong snapKeysIteratedLast;
    @Metric(value={"Snapshot: No. of not reclaimable keys the last run"})
    private MutableGaugeLong snapKeysNotReclaimableLast;
    @Metric(value={"Last Purge Key termIndex on Active Object Store"})
    private MutableGaugeLong lastAOSPurgeTermId;
    @Metric(value={"Last Purge Key transactionId on Active Object Store"})
    private MutableGaugeLong lastAOSPurgeTransactionId;

    private DeletingServiceMetrics() {
    }

    public static DeletingServiceMetrics create() {
        return (DeletingServiceMetrics)DefaultMetricsSystem.instance().register(METRICS_SOURCE_NAME, "Metrics tracking the progress of deletion of directories and keys in the OM", (Object)new DeletingServiceMetrics());
    }

    public static void unregister() {
        DefaultMetricsSystem.instance().unregisterSource(METRICS_SOURCE_NAME);
    }

    public void incrNumDirsSentForPurge(long dirDel) {
        this.numDirsSentForPurge.incr(dirDel);
    }

    public void incrNumSubDirsSentForPurge(long delta) {
        this.numSubDirsSentForPurge.incr(delta);
    }

    public void incrNumSubFilesSentForPurge(long delta) {
        this.numSubFilesSentForPurge.incr(delta);
    }

    public void incrementDirectoryDeletionTotalMetrics(long dirDel, long dirMove, long filesMove) {
        this.incrNumDirsSentForPurge(dirDel);
        this.incrNumSubDirsSentForPurge(dirMove);
        this.incrNumSubFilesSentForPurge(filesMove);
    }

    public long getNumDirsSentForPurge() {
        return this.numDirsSentForPurge.value();
    }

    public long getNumSubDirsSentForPurge() {
        return this.numSubDirsSentForPurge.value();
    }

    public long getNumSubFilesSentForPurge() {
        return this.numSubFilesSentForPurge.value();
    }

    public void incrNumKeysProcessed(long keysProcessed) {
        this.numKeysProcessed.incr(keysProcessed);
    }

    public void incrNumKeysSentForPurge(long keysPurge) {
        this.numKeysSentForPurge.incr(keysPurge);
    }

    public void incrNumDirPurged(long dirPurged) {
        this.numDirsPurged.incr(dirPurged);
    }

    public void incrNumSubFilesMoved(long subKeys) {
        this.numSubFilesMovedToDeletedTable.incr(subKeys);
    }

    public void incrNumSubDirectoriesMoved(long subDirectories) {
        this.numSubDirsMovedToDeletedDirTable.incr(subDirectories);
    }

    public long getNumDirsPurged() {
        return this.numDirsPurged.value();
    }

    public long getNumSubFilesMovedToDeletedTable() {
        return this.numSubFilesMovedToDeletedTable.value();
    }

    public long getNumSubDirsMovedToDeletedDirTable() {
        return this.numSubDirsMovedToDeletedDirTable.value();
    }

    public void incrNumKeysPurged(long keysPurged) {
        this.numKeysPurged.incr(keysPurged);
    }

    public void incrNumRenameEntriesPurged(long renameEntriesPurged) {
        this.numRenameEntriesPurged.incr(renameEntriesPurged);
    }

    public void setKdsLastRunTimestamp(long timestamp) {
        this.kdsLastRunTimestamp.set(timestamp);
    }

    public void setKdsCurRunTimestamp(long timestamp) {
        this.kdsCurRunTimestamp.set(timestamp);
    }

    private void resetMetrics() {
        this.keysReclaimedInInterval.set(0L);
        this.reclaimedSizeInInterval.set(0L);
    }

    private void checkAndResetMetrics() {
        long currentTime = Instant.now().getEpochSecond();
        if (this.metricsResetTimeStamp.value() == 0L) {
            this.metricsResetTimeStamp.set(currentTime);
        }
        if (currentTime - this.metricsResetTimeStamp.value() > METRIC_RESET_INTERVAL) {
            this.resetMetrics();
            this.metricsResetTimeStamp.set(currentTime);
        }
    }

    public void updateIntervalCumulativeMetrics(long keysReclaimed, long replicatedSizeBytes) {
        this.checkAndResetMetrics();
        this.keysReclaimedInInterval.incr(keysReclaimed);
        this.reclaimedSizeInInterval.incr(replicatedSizeBytes);
    }

    public long getKeysReclaimedInInterval() {
        return this.keysReclaimedInInterval.value();
    }

    public long getReclaimedSizeInInterval() {
        return this.reclaimedSizeInInterval.value();
    }

    public void updateAosLastRunMetrics(long keysReclaimed, long replicatedSizeBytes, long iteratedKeys, long notReclaimableKeys) {
        this.aosKeysReclaimedLast.set(keysReclaimed);
        this.aosReclaimedSizeLast.set(replicatedSizeBytes);
        this.aosKeysIteratedLast.set(iteratedKeys);
        this.aosKeysNotReclaimableLast.set(notReclaimableKeys);
    }

    public long getAosKeysReclaimedLast() {
        return this.aosKeysReclaimedLast.value();
    }

    public long getAosReclaimedSizeLast() {
        return this.aosReclaimedSizeLast.value();
    }

    public long getAosKeysIteratedLast() {
        return this.aosKeysIteratedLast.value();
    }

    public long getAosKeysNotReclaimableLast() {
        return this.aosKeysNotReclaimableLast.value();
    }

    public void updateSnapLastRunMetrics(long keysReclaimed, long replicatedSizeBytes, long iteratedKeys, long notReclaimableKeys) {
        this.snapKeysReclaimedLast.set(keysReclaimed);
        this.snapReclaimedSizeLast.set(replicatedSizeBytes);
        this.snapKeysIteratedLast.set(iteratedKeys);
        this.snapKeysNotReclaimableLast.set(notReclaimableKeys);
    }

    public long getSnapKeysReclaimedLast() {
        return this.snapKeysReclaimedLast.value();
    }

    public long getSnapReclaimedSizeLast() {
        return this.snapReclaimedSizeLast.value();
    }

    public long getSnapKeysIteratedLast() {
        return this.snapKeysIteratedLast.value();
    }

    public long getSnapKeysNotReclaimableLast() {
        return this.snapKeysNotReclaimableLast.value();
    }

    public synchronized TransactionInfo getLastAOSTransactionInfo() {
        return TransactionInfo.valueOf((long)this.lastAOSPurgeTermId.value(), (long)this.lastAOSPurgeTransactionId.value());
    }

    public synchronized void setLastAOSTransactionInfo(TransactionInfo transactionInfo) {
        TransactionInfo previousTransactionInfo = this.getLastAOSTransactionInfo();
        if (transactionInfo.compareTo(previousTransactionInfo) > 0) {
            this.lastAOSPurgeTermId.set(transactionInfo.getTerm());
            this.lastAOSPurgeTransactionId.set(transactionInfo.getTransactionIndex());
        }
    }

    @VisibleForTesting
    public void resetDirectoryMetrics() {
        this.numDirsPurged.set(0L);
        this.numSubFilesMovedToDeletedTable.set(0L);
        this.numSubDirsMovedToDeletedDirTable.set(0L);
        this.numDirsSentForPurge.set(0L);
        this.numSubDirsSentForPurge.set(0L);
        this.numSubFilesSentForPurge.set(0L);
    }
}

