/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.org.bouncycastle.cms.bc;

import org.apache.ozone.shaded.org.bouncycastle.cert.X509CertificateHolder;
import org.apache.ozone.shaded.org.bouncycastle.cms.CMSSignatureAlgorithmNameGenerator;
import org.apache.ozone.shaded.org.bouncycastle.cms.SignerInformationVerifier;
import org.apache.ozone.shaded.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.apache.ozone.shaded.org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import org.apache.ozone.shaded.org.bouncycastle.operator.DigestCalculatorProvider;
import org.apache.ozone.shaded.org.bouncycastle.operator.OperatorCreationException;
import org.apache.ozone.shaded.org.bouncycastle.operator.SignatureAlgorithmIdentifierFinder;
import org.apache.ozone.shaded.org.bouncycastle.operator.bc.BcEdDSAContentVerifierProviderBuilder;

public class BcEdDSASignerInfoVerifierBuilder {
    private BcEdDSAContentVerifierProviderBuilder contentVerifierProviderBuilder;
    private DigestCalculatorProvider digestCalculatorProvider;
    private CMSSignatureAlgorithmNameGenerator sigAlgNameGen;
    private SignatureAlgorithmIdentifierFinder sigAlgIdFinder;

    public BcEdDSASignerInfoVerifierBuilder(CMSSignatureAlgorithmNameGenerator cMSSignatureAlgorithmNameGenerator, SignatureAlgorithmIdentifierFinder signatureAlgorithmIdentifierFinder, DigestAlgorithmIdentifierFinder digestAlgorithmIdentifierFinder, DigestCalculatorProvider digestCalculatorProvider) {
        this.sigAlgNameGen = cMSSignatureAlgorithmNameGenerator;
        this.sigAlgIdFinder = signatureAlgorithmIdentifierFinder;
        this.contentVerifierProviderBuilder = new BcEdDSAContentVerifierProviderBuilder();
        this.digestCalculatorProvider = digestCalculatorProvider;
    }

    public SignerInformationVerifier build(X509CertificateHolder x509CertificateHolder) throws OperatorCreationException {
        return new SignerInformationVerifier(this.sigAlgNameGen, this.sigAlgIdFinder, this.contentVerifierProviderBuilder.build(x509CertificateHolder), this.digestCalculatorProvider);
    }

    public SignerInformationVerifier build(AsymmetricKeyParameter asymmetricKeyParameter) throws OperatorCreationException {
        return new SignerInformationVerifier(this.sigAlgNameGen, this.sigAlgIdFinder, this.contentVerifierProviderBuilder.build(asymmetricKeyParameter), this.digestCalculatorProvider);
    }
}

