/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.org.bouncycastle.asn1.x9;

import org.apache.ozone.shaded.org.bouncycastle.asn1.ASN1BitString;
import org.apache.ozone.shaded.org.bouncycastle.asn1.ASN1Integer;
import org.apache.ozone.shaded.org.bouncycastle.asn1.ASN1Object;
import org.apache.ozone.shaded.org.bouncycastle.asn1.ASN1Primitive;
import org.apache.ozone.shaded.org.bouncycastle.asn1.ASN1Sequence;
import org.apache.ozone.shaded.org.bouncycastle.asn1.ASN1TaggedObject;
import org.apache.ozone.shaded.org.bouncycastle.asn1.DERSequence;

public class DHValidationParms
extends ASN1Object {
    private ASN1BitString seed;
    private ASN1Integer pgenCounter;

    public static DHValidationParms getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DHValidationParms.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static DHValidationParms getInstance(Object object) {
        if (object instanceof DHValidationParms) {
            return (DHValidationParms)object;
        }
        if (object != null) {
            return new DHValidationParms(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public DHValidationParms(ASN1BitString aSN1BitString, ASN1Integer aSN1Integer) {
        if (aSN1BitString == null) {
            throw new IllegalArgumentException("'seed' cannot be null");
        }
        if (aSN1Integer == null) {
            throw new IllegalArgumentException("'pgenCounter' cannot be null");
        }
        this.seed = aSN1BitString;
        this.pgenCounter = aSN1Integer;
    }

    private DHValidationParms(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() != 2) {
            throw new IllegalArgumentException("Bad sequence size: " + aSN1Sequence.size());
        }
        this.seed = ASN1BitString.getInstance(aSN1Sequence.getObjectAt(0));
        this.pgenCounter = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(1));
    }

    public ASN1BitString getSeed() {
        return this.seed;
    }

    public ASN1Integer getPgenCounter() {
        return this.pgenCounter;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new DERSequence(this.seed, this.pgenCounter);
    }
}

