/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.opencensus.metrics.export;

import javax.annotation.concurrent.Immutable;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.opencensus.common.Function;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.opencensus.metrics.export.AutoValue_Value_ValueDistribution;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.opencensus.metrics.export.AutoValue_Value_ValueDouble;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.opencensus.metrics.export.AutoValue_Value_ValueLong;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.opencensus.metrics.export.AutoValue_Value_ValueSummary;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.opencensus.metrics.export.Distribution;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.opencensus.metrics.export.Summary;

@Immutable
public abstract class Value {
    Value() {
    }

    public static Value doubleValue(double value) {
        return ValueDouble.create(value);
    }

    public static Value longValue(long value) {
        return ValueLong.create(value);
    }

    public static Value distributionValue(Distribution value) {
        return ValueDistribution.create(value);
    }

    public static Value summaryValue(Summary value) {
        return ValueSummary.create(value);
    }

    public abstract <T> T match(Function<? super Double, T> var1, Function<? super Long, T> var2, Function<? super Distribution, T> var3, Function<? super Summary, T> var4, Function<? super Value, T> var5);

    @Immutable
    static abstract class ValueSummary
    extends Value {
        ValueSummary() {
        }

        @Override
        public final <T> T match(Function<? super Double, T> doubleFunction, Function<? super Long, T> longFunction, Function<? super Distribution, T> distributionFunction, Function<? super Summary, T> summaryFunction, Function<? super Value, T> defaultFunction) {
            return summaryFunction.apply(this.getValue());
        }

        static ValueSummary create(Summary value) {
            return new AutoValue_Value_ValueSummary(value);
        }

        abstract Summary getValue();
    }

    @Immutable
    static abstract class ValueDistribution
    extends Value {
        ValueDistribution() {
        }

        @Override
        public final <T> T match(Function<? super Double, T> doubleFunction, Function<? super Long, T> longFunction, Function<? super Distribution, T> distributionFunction, Function<? super Summary, T> summaryFunction, Function<? super Value, T> defaultFunction) {
            return distributionFunction.apply(this.getValue());
        }

        static ValueDistribution create(Distribution value) {
            return new AutoValue_Value_ValueDistribution(value);
        }

        abstract Distribution getValue();
    }

    @Immutable
    static abstract class ValueLong
    extends Value {
        ValueLong() {
        }

        @Override
        public final <T> T match(Function<? super Double, T> doubleFunction, Function<? super Long, T> longFunction, Function<? super Distribution, T> distributionFunction, Function<? super Summary, T> summaryFunction, Function<? super Value, T> defaultFunction) {
            return longFunction.apply(this.getValue());
        }

        static ValueLong create(long value) {
            return new AutoValue_Value_ValueLong(value);
        }

        abstract long getValue();
    }

    @Immutable
    static abstract class ValueDouble
    extends Value {
        ValueDouble() {
        }

        @Override
        public final <T> T match(Function<? super Double, T> doubleFunction, Function<? super Long, T> longFunction, Function<? super Distribution, T> distributionFunction, Function<? super Summary, T> summaryFunction, Function<? super Value, T> defaultFunction) {
            return doubleFunction.apply(this.getValue());
        }

        static ValueDouble create(double value) {
            return new AutoValue_Value_ValueDouble(value);
        }

        abstract double getValue();
    }
}

