/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.org.apache.ratis.protocol;

import java.util.Objects;
import java.util.Optional;
import org.apache.ozone.shaded.org.apache.ratis.proto.RaftProtos;
import org.apache.ozone.shaded.org.apache.ratis.protocol.ClientId;
import org.apache.ozone.shaded.org.apache.ratis.protocol.RaftClientMessage;
import org.apache.ozone.shaded.org.apache.ratis.protocol.RaftId;

public final class ClientInvocationId {
    private final ClientId clientId;
    private final long longId;

    public static ClientInvocationId valueOf(ClientId clientId, long invocationId) {
        return new ClientInvocationId(clientId, invocationId);
    }

    public static ClientInvocationId valueOf(RaftClientMessage message) {
        return ClientInvocationId.valueOf(message.getClientId(), message.getCallId());
    }

    public static ClientInvocationId valueOf(RaftProtos.StateMachineLogEntryProto proto) {
        return ClientInvocationId.valueOf(ClientId.valueOf(proto.getClientId()), proto.getCallId());
    }

    private ClientInvocationId(ClientId clientId, long longId) {
        this.clientId = clientId;
        this.longId = longId;
    }

    public ClientId getClientId() {
        return this.clientId;
    }

    public long getLongId() {
        return this.longId;
    }

    public boolean match(RaftProtos.StateMachineLogEntryProto proto) {
        return this.longId == proto.getCallId() && Optional.ofNullable(this.clientId).map(RaftId::toByteString).filter(b -> b.equals(proto.getClientId())).isPresent();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ClientInvocationId that = (ClientInvocationId)obj;
        return this.longId == that.longId && Objects.equals(this.clientId, that.clientId);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.longId);
    }

    public String toString() {
        return this.longId + "@" + this.clientId;
    }
}

