/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.org.apache.commons.validator.routines;

import java.io.Serializable;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexValidator
implements Serializable {
    private static final long serialVersionUID = -8832409930574867162L;
    private static final int CASE_SENSITIVE = 0;
    private final Pattern[] patterns;

    private static int toCompileFlags(boolean caseSensitive) {
        return caseSensitive ? 0 : 2;
    }

    private RegexValidator(int flags, String ... regexs) {
        if (regexs == null || regexs.length == 0) {
            throw new IllegalArgumentException("Regular expressions are missing");
        }
        this.patterns = new Pattern[regexs.length];
        for (int i = 0; i < regexs.length; ++i) {
            String regex = regexs[i];
            if (regex == null || regex.isEmpty()) {
                throw new IllegalArgumentException("Regular expression[" + i + "] is missing");
            }
            this.patterns[i] = Pattern.compile(regex, flags);
        }
    }

    RegexValidator(List<String> regexs) {
        this(0, regexs.toArray(new String[0]));
    }

    public RegexValidator(String regex) {
        this(0, regex);
    }

    public RegexValidator(String ... regexs) {
        this(0, regexs);
    }

    public RegexValidator(String regex, boolean caseSensitive) {
        this(RegexValidator.toCompileFlags(caseSensitive), regex);
    }

    public RegexValidator(String[] regexs, boolean caseSensitive) {
        this(RegexValidator.toCompileFlags(caseSensitive), regexs);
    }

    public Pattern[] getPatterns() {
        return (Pattern[])this.patterns.clone();
    }

    public boolean isValid(String value) {
        if (value == null) {
            return false;
        }
        for (Pattern pattern : this.patterns) {
            if (!pattern.matcher(value).matches()) continue;
            return true;
        }
        return false;
    }

    public String[] match(String value) {
        if (value == null) {
            return null;
        }
        for (Pattern pattern : this.patterns) {
            Matcher matcher = pattern.matcher(value);
            if (!matcher.matches()) continue;
            int count = matcher.groupCount();
            String[] groups2 = new String[count];
            for (int j = 0; j < count; ++j) {
                groups2[j] = matcher.group(j + 1);
            }
            return groups2;
        }
        return null;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("RegexValidator{");
        for (int i = 0; i < this.patterns.length; ++i) {
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append(this.patterns[i].pattern());
        }
        buffer.append("}");
        return buffer.toString();
    }

    public String validate(String value) {
        if (value == null) {
            return null;
        }
        for (Pattern pattern : this.patterns) {
            Matcher matcher = pattern.matcher(value);
            if (!matcher.matches()) continue;
            int count = matcher.groupCount();
            if (count == 1) {
                return matcher.group(1);
            }
            StringBuilder buffer = new StringBuilder();
            for (int j = 0; j < count; ++j) {
                String component = matcher.group(j + 1);
                if (component == null) continue;
                buffer.append(component);
            }
            return buffer.toString();
        }
        return null;
    }
}

