/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.okhttp3.internal.http;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.security.cert.CertificateException;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.ozone.shaded.kotlin.Metadata;
import org.apache.ozone.shaded.kotlin.collections.CollectionsKt;
import org.apache.ozone.shaded.kotlin.jvm.internal.DefaultConstructorMarker;
import org.apache.ozone.shaded.kotlin.jvm.internal.Intrinsics;
import org.apache.ozone.shaded.kotlin.text.Regex;
import org.apache.ozone.shaded.okhttp3.HttpUrl;
import org.apache.ozone.shaded.okhttp3.Interceptor;
import org.apache.ozone.shaded.okhttp3.OkHttpClient;
import org.apache.ozone.shaded.okhttp3.Request;
import org.apache.ozone.shaded.okhttp3.RequestBody;
import org.apache.ozone.shaded.okhttp3.Response;
import org.apache.ozone.shaded.okhttp3.Route;
import org.apache.ozone.shaded.okhttp3.internal.UnreadableResponseBodyKt;
import org.apache.ozone.shaded.okhttp3.internal._UtilCommonKt;
import org.apache.ozone.shaded.okhttp3.internal._UtilJvmKt;
import org.apache.ozone.shaded.okhttp3.internal.connection.Exchange;
import org.apache.ozone.shaded.okhttp3.internal.connection.RealCall;
import org.apache.ozone.shaded.okhttp3.internal.connection.RealConnection;
import org.apache.ozone.shaded.okhttp3.internal.http.HttpMethod;
import org.apache.ozone.shaded.okhttp3.internal.http.RealInterceptorChain;
import org.apache.ozone.shaded.okhttp3.internal.http2.ConnectionShutdownException;
import org.apache.ozone.shaded.org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0016\u001a\u00020\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/apache/ozone/shaded/okhttp3/internal/http/RetryAndFollowUpInterceptor;", "Lorg/apache/ozone/shaded/okhttp3/Interceptor;", "client", "Lorg/apache/ozone/shaded/okhttp3/OkHttpClient;", "<init>", "(Lokhttp3/OkHttpClient;)V", "intercept", "Lorg/apache/ozone/shaded/okhttp3/Response;", "chain", "Lorg/apache/ozone/shaded/okhttp3/Interceptor$Chain;", "recover", "", "e", "Ljava/io/IOException;", "call", "Lorg/apache/ozone/shaded/okhttp3/internal/connection/RealCall;", "userRequest", "Lorg/apache/ozone/shaded/okhttp3/Request;", "requestIsOneShot", "isRecoverable", "requestSendStarted", "followUpRequest", "userResponse", "exchange", "Lorg/apache/ozone/shaded/okhttp3/internal/connection/Exchange;", "buildRedirectRequest", "method", "", "retryAfter", "", "defaultDelay", "Companion", "okhttp"})
public final class RetryAndFollowUpInterceptor
implements Interceptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OkHttpClient client;
    private static final int MAX_FOLLOW_UPS = 20;

    public RetryAndFollowUpInterceptor(@NotNull OkHttpClient client) {
        Intrinsics.checkNotNullParameter(client, "client");
        this.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Intrinsics.checkNotNullParameter(chain, "chain");
        RealInterceptorChain realChain = (RealInterceptorChain)chain;
        Request request = ((RealInterceptorChain)chain).getRequest$okhttp();
        RealCall call = realChain.getCall$okhttp();
        int followUpCount = 0;
        Response priorResponse = null;
        boolean newRoutePlanner = true;
        List<Object> recoveredFailures = CollectionsKt.emptyList();
        while (true) {
            call.enterNetworkInterceptorExchange(request, newRoutePlanner, (RealInterceptorChain)chain);
            Response response = null;
            boolean closeActiveExchange = true;
            if (call.isCanceled()) {
                throw new IOException("Canceled");
            }
            try {
                response = realChain.proceed(request);
                newRoutePlanner = true;
            }
            catch (IOException e) {
                boolean isRecoverable = this.recover(e, call, request);
                call.getEventListener$okhttp().retryDecision(call, e, isRecoverable);
                if (!isRecoverable) {
                    throw _UtilCommonKt.withSuppressed(e, recoveredFailures);
                }
                recoveredFailures = CollectionsKt.plus((Collection)recoveredFailures, e);
                newRoutePlanner = false;
                call.exitNetworkInterceptorExchange$okhttp(closeActiveExchange);
            }
            try {
                Response response2 = priorResponse;
                response = response.newBuilder().request(request).priorResponse(response2 != null ? UnreadableResponseBodyKt.stripBody(response2) : null).build();
                Exchange exchange = call.getInterceptorScopedExchange$okhttp();
                Request followUp = this.followUpRequest(response, exchange);
                if (followUp == null) {
                    if (exchange != null && exchange.isDuplex$okhttp()) {
                        call.timeoutEarlyExit();
                    }
                    closeActiveExchange = false;
                    call.getEventListener$okhttp().followUpDecision(call, response, null);
                    Response response3 = response;
                    return response3;
                }
                RequestBody followUpBody = followUp.body();
                if (followUpBody != null && followUpBody.isOneShot()) {
                    closeActiveExchange = false;
                    call.getEventListener$okhttp().followUpDecision(call, response, null);
                    Response response4 = response;
                    return response4;
                }
                _UtilCommonKt.closeQuietly(response.body());
                if (++followUpCount > 20) {
                    call.getEventListener$okhttp().followUpDecision(call, response, null);
                    throw new ProtocolException("Too many follow-up requests: " + followUpCount);
                }
                call.getEventListener$okhttp().followUpDecision(call, response, followUp);
                request = followUp;
                priorResponse = response;
                continue;
            }
            finally {
                call.exitNetworkInterceptorExchange$okhttp(closeActiveExchange);
                continue;
            }
            break;
        }
    }

    private final boolean recover(IOException e, RealCall call, Request userRequest) {
        boolean requestSendStarted;
        boolean bl = requestSendStarted = !(e instanceof ConnectionShutdownException);
        if (!this.client.retryOnConnectionFailure()) {
            return false;
        }
        if (requestSendStarted && this.requestIsOneShot(e, userRequest)) {
            return false;
        }
        if (!this.isRecoverable(e, requestSendStarted)) {
            return false;
        }
        return call.retryAfterFailure();
    }

    private final boolean requestIsOneShot(IOException e, Request userRequest) {
        RequestBody requestBody = userRequest.body();
        return requestBody != null && requestBody.isOneShot() || e instanceof FileNotFoundException;
    }

    private final boolean isRecoverable(IOException e, boolean requestSendStarted) {
        if (e instanceof ProtocolException) {
            return false;
        }
        if (e instanceof InterruptedIOException) {
            return e instanceof SocketTimeoutException && !requestSendStarted;
        }
        if (e instanceof SSLHandshakeException && e.getCause() instanceof CertificateException) {
            return false;
        }
        return !(e instanceof SSLPeerUnverifiedException);
    }

    private final Request followUpRequest(Response userResponse, Exchange exchange) throws IOException {
        Object object = exchange;
        Route route = object != null && (object = ((Exchange)object).getConnection$okhttp()) != null ? ((RealConnection)object).route() : null;
        int responseCode = userResponse.code();
        String method = userResponse.request().method();
        switch (responseCode) {
            case 407: {
                Route route2 = route;
                Intrinsics.checkNotNull(route2);
                Proxy selectedProxy = route2.proxy();
                if (selectedProxy.type() != Proxy.Type.HTTP) {
                    throw new ProtocolException("Received HTTP_PROXY_AUTH (407) code while not using proxy");
                }
                return this.client.proxyAuthenticator().authenticate(route, userResponse);
            }
            case 401: {
                return this.client.authenticator().authenticate(route, userResponse);
            }
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 307: 
            case 308: {
                return this.buildRedirectRequest(userResponse, method);
            }
            case 408: {
                if (!this.client.retryOnConnectionFailure()) {
                    return null;
                }
                RequestBody requestBody = userResponse.request().body();
                if (requestBody != null && requestBody.isOneShot()) {
                    return null;
                }
                Response priorResponse = userResponse.priorResponse();
                if (priorResponse != null && priorResponse.code() == 408) {
                    return null;
                }
                if (this.retryAfter(userResponse, 0) > 0) {
                    return null;
                }
                return userResponse.request();
            }
            case 503: {
                Response priorResponse = userResponse.priorResponse();
                if (priorResponse != null && priorResponse.code() == 503) {
                    return null;
                }
                if (this.retryAfter(userResponse, Integer.MAX_VALUE) == 0) {
                    return userResponse.request();
                }
                return null;
            }
            case 421: {
                RequestBody requestBody = userResponse.request().body();
                if (requestBody != null && requestBody.isOneShot()) {
                    return null;
                }
                if (exchange == null || !exchange.isCoalescedConnection$okhttp()) {
                    return null;
                }
                exchange.getConnection$okhttp().noCoalescedConnections$okhttp();
                return userResponse.request();
            }
        }
        return null;
    }

    private final Request buildRedirectRequest(Response userResponse, String method) {
        if (!this.client.followRedirects()) {
            return null;
        }
        String string = Response.header$default(userResponse, "Location", null, 2, null);
        if (string == null) {
            return null;
        }
        String location = string;
        HttpUrl httpUrl = userResponse.request().url().resolve(location);
        if (httpUrl == null) {
            return null;
        }
        HttpUrl url = httpUrl;
        boolean sameScheme = Intrinsics.areEqual(url.scheme(), userResponse.request().url().scheme());
        if (!sameScheme && !this.client.followSslRedirects()) {
            return null;
        }
        Request.Builder requestBuilder = userResponse.request().newBuilder();
        if (HttpMethod.permitsRequestBody(method)) {
            Request.Builder builder;
            boolean maintainBody;
            int responseCode = userResponse.code();
            boolean bl = maintainBody = HttpMethod.INSTANCE.redirectsWithBody(method) || responseCode == 308 || responseCode == 307;
            if (HttpMethod.INSTANCE.redirectsToGet(method) && responseCode != 308 && responseCode != 307) {
                builder = requestBuilder.method("GET", null);
            } else {
                RequestBody requestBody = maintainBody ? userResponse.request().body() : null;
                builder = requestBuilder.method(method, requestBody);
            }
            if (!maintainBody) {
                requestBuilder.removeHeader("Transfer-Encoding");
                requestBuilder.removeHeader("Content-Length");
                requestBuilder.removeHeader("Content-Type");
            }
        }
        if (!_UtilJvmKt.canReuseConnectionFor(userResponse.request().url(), url)) {
            requestBuilder.removeHeader("Authorization");
        }
        return requestBuilder.url(url).build();
    }

    private final int retryAfter(Response userResponse, int defaultDelay) {
        String string = Response.header$default(userResponse, "Retry-After", null, 2, null);
        if (string == null) {
            return defaultDelay;
        }
        String header = string;
        CharSequence charSequence = header;
        if (new Regex("\\d+").matches(charSequence)) {
            Integer n = Integer.valueOf(header);
            Intrinsics.checkNotNullExpressionValue(n, "valueOf(...)");
            return ((Number)n).intValue();
        }
        return Integer.MAX_VALUE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/apache/ozone/shaded/okhttp3/internal/http/RetryAndFollowUpInterceptor$Companion;", "", "<init>", "()V", "MAX_FOLLOW_UPS", "", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

