/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.io.opentelemetry.exporter.internal.otlp.metrics;

import java.util.Collection;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.BiFunction;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.marshal.Marshaler;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.otlp.metrics.LowAllocationMetricsRequestMarshaler;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.otlp.metrics.MetricsRequestMarshaler;
import org.apache.ozone.shaded.io.opentelemetry.sdk.common.CompletableResultCode;
import org.apache.ozone.shaded.io.opentelemetry.sdk.common.export.MemoryMode;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.data.MetricData;

public class MetricReusableDataMarshaler {
    private final Deque<LowAllocationMetricsRequestMarshaler> marshalerPool = new ConcurrentLinkedDeque<LowAllocationMetricsRequestMarshaler>();
    private final MemoryMode memoryMode;
    private final BiFunction<Marshaler, Integer, CompletableResultCode> doExport;

    public MetricReusableDataMarshaler(MemoryMode memoryMode, BiFunction<Marshaler, Integer, CompletableResultCode> doExport) {
        this.memoryMode = memoryMode;
        this.doExport = doExport;
    }

    public MemoryMode getMemoryMode() {
        return this.memoryMode;
    }

    public CompletableResultCode export(Collection<MetricData> metrics) {
        if (this.memoryMode == MemoryMode.REUSABLE_DATA) {
            LowAllocationMetricsRequestMarshaler marshaler = this.marshalerPool.poll();
            if (marshaler == null) {
                marshaler = new LowAllocationMetricsRequestMarshaler();
            }
            LowAllocationMetricsRequestMarshaler exportMarshaler = marshaler;
            exportMarshaler.initialize(metrics);
            return this.doExport.apply(exportMarshaler, metrics.size()).whenComplete(() -> {
                exportMarshaler.reset();
                this.marshalerPool.add(exportMarshaler);
            });
        }
        MetricsRequestMarshaler request = MetricsRequestMarshaler.create(metrics);
        return this.doExport.apply(request, metrics.size());
    }
}

