/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.io.opentelemetry.exporter.internal.otlp.logs;

import java.io.IOException;
import java.util.List;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.marshal.Marshaler;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.marshal.Serializer;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.otlp.InstrumentationScopeMarshaler;
import org.apache.ozone.shaded.io.opentelemetry.proto.logs.v1.internal.ScopeLogs;

final class InstrumentationScopeLogsMarshaler
extends MarshalerWithSize {
    private final InstrumentationScopeMarshaler instrumentationScope;
    private final List<Marshaler> logMarshalers;
    private final byte[] schemaUrlUtf8;

    InstrumentationScopeLogsMarshaler(InstrumentationScopeMarshaler instrumentationScope, byte[] schemaUrlUtf8, List<Marshaler> logMarshalers) {
        super(InstrumentationScopeLogsMarshaler.calculateSize(instrumentationScope, schemaUrlUtf8, logMarshalers));
        this.instrumentationScope = instrumentationScope;
        this.schemaUrlUtf8 = schemaUrlUtf8;
        this.logMarshalers = logMarshalers;
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        output.serializeMessage(ScopeLogs.SCOPE, this.instrumentationScope);
        output.serializeRepeatedMessage(ScopeLogs.LOG_RECORDS, this.logMarshalers);
        output.serializeString(ScopeLogs.SCHEMA_URL, this.schemaUrlUtf8);
    }

    private static int calculateSize(InstrumentationScopeMarshaler instrumentationScope, byte[] schemaUrlUtf8, List<Marshaler> logMarshalers) {
        int size = 0;
        size += MarshalerUtil.sizeMessage(ScopeLogs.SCOPE, instrumentationScope);
        size += MarshalerUtil.sizeBytes(ScopeLogs.SCHEMA_URL, schemaUrlUtf8);
        return size += MarshalerUtil.sizeRepeatedMessage(ScopeLogs.LOG_RECORDS, logMarshalers);
    }
}

