/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.io.opentelemetry.exporter.internal.marshal;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.ozone.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.marshal.JsonSerializer;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.marshal.ProtoSerializer;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.marshal.Serializer;

public abstract class Marshaler {
    public final void writeBinaryTo(OutputStream output) throws IOException {
        try (ProtoSerializer serializer = new ProtoSerializer(output);){
            this.writeTo(serializer);
        }
    }

    public final void writeJsonTo(OutputStream output) throws IOException {
        try (JsonSerializer serializer = new JsonSerializer(output);){
            serializer.writeMessageValue(this);
        }
    }

    public final void writeJsonToGenerator(JsonGenerator output) throws IOException {
        try (JsonSerializer serializer = new JsonSerializer(output);){
            serializer.writeMessageValue(this);
        }
    }

    public final void writeJsonWithNewline(JsonGenerator output) throws IOException {
        try (JsonSerializer serializer = new JsonSerializer(output);){
            serializer.writeMessageValue(this);
            output.writeRaw('\n');
        }
    }

    public abstract int getBinarySerializedSize();

    protected abstract void writeTo(Serializer var1) throws IOException;
}

