/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.erasurecode.rawcoder.util;

import java.nio.ByteBuffer;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.ozone.erasurecode.rawcoder.util.GF256;
import org.apache.ozone.erasurecode.rawcoder.util.GaloisField;

@InterfaceAudience.Private
public final class RSUtil {
    public static final GaloisField GF = GaloisField.getInstance();
    public static final int PRIMITIVE_ROOT = 2;

    private RSUtil() {
    }

    public static int[] getPrimitivePower(int numDataUnits, int numParityUnits) {
        int[] primitivePower = new int[numDataUnits + numParityUnits];
        for (int i = 0; i < numDataUnits + numParityUnits; ++i) {
            primitivePower[i] = GF.power(2, i);
        }
        return primitivePower;
    }

    public static void initTables(int k, int rows, byte[] codingMatrix, int matrixOffset, byte[] gfTables) {
        int offset = 0;
        int idx = matrixOffset;
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < k; ++j) {
                GF256.gfVectMulInit(codingMatrix[idx++], gfTables, offset);
                offset += 32;
            }
        }
    }

    public static void genCauchyMatrix(byte[] a, int m4, int k) {
        for (int i = 0; i < k; ++i) {
            a[k * i + i] = 1;
        }
        int pos = k * k;
        for (int i = k; i < m4; ++i) {
            for (int j = 0; j < k; ++j) {
                a[pos++] = GF256.gfInv((byte)(i ^ j));
            }
        }
    }

    public static void encodeData(byte[] gfTables, int dataLen, byte[][] inputs, int[] inputOffsets, byte[][] outputs, int[] outputOffsets) {
        int numInputs = inputs.length;
        int numOutputs = outputs.length;
        int times = dataLen / 8;
        int extra = dataLen - dataLen % 8;
        for (int l = 0; l < numOutputs; ++l) {
            byte[] output = outputs[l];
            for (int j = 0; j < numInputs; ++j) {
                byte[] input = inputs[j];
                int iPos = inputOffsets[j];
                int oPos = outputOffsets[l];
                byte s2 = gfTables[j * 32 + l * numInputs * 32 + 1];
                byte[] tableLine = GF256.gfMulTab()[s2 & 0xFF];
                int i = 0;
                while (i < times) {
                    int n = oPos + 0;
                    output[n] = (byte)(output[n] ^ tableLine[0xFF & input[iPos + 0]]);
                    int n2 = oPos + 1;
                    output[n2] = (byte)(output[n2] ^ tableLine[0xFF & input[iPos + 1]]);
                    int n3 = oPos + 2;
                    output[n3] = (byte)(output[n3] ^ tableLine[0xFF & input[iPos + 2]]);
                    int n4 = oPos + 3;
                    output[n4] = (byte)(output[n4] ^ tableLine[0xFF & input[iPos + 3]]);
                    int n5 = oPos + 4;
                    output[n5] = (byte)(output[n5] ^ tableLine[0xFF & input[iPos + 4]]);
                    int n6 = oPos + 5;
                    output[n6] = (byte)(output[n6] ^ tableLine[0xFF & input[iPos + 5]]);
                    int n7 = oPos + 6;
                    output[n7] = (byte)(output[n7] ^ tableLine[0xFF & input[iPos + 6]]);
                    int n8 = oPos + 7;
                    output[n8] = (byte)(output[n8] ^ tableLine[0xFF & input[iPos + 7]]);
                    ++i;
                    iPos += 8;
                    oPos += 8;
                }
                i = extra;
                while (i < dataLen) {
                    int n = oPos++;
                    output[n] = (byte)(output[n] ^ tableLine[0xFF & input[iPos]]);
                    ++i;
                    ++iPos;
                }
            }
        }
    }

    public static void encodeData(byte[] gfTables, ByteBuffer[] inputs, ByteBuffer[] outputs) {
        int numInputs = inputs.length;
        int numOutputs = outputs.length;
        int dataLen = inputs[0].remaining();
        int times = dataLen / 8;
        int extra = dataLen - dataLen % 8;
        for (int l = 0; l < numOutputs; ++l) {
            ByteBuffer output = outputs[l];
            for (int j = 0; j < numInputs; ++j) {
                ByteBuffer input = inputs[j];
                int iPos = input.position();
                int oPos = output.position();
                byte s2 = gfTables[j * 32 + l * numInputs * 32 + 1];
                byte[] tableLine = GF256.gfMulTab()[s2 & 0xFF];
                int i = 0;
                while (i < times) {
                    output.put(oPos + 0, (byte)(output.get(oPos + 0) ^ tableLine[0xFF & input.get(iPos + 0)]));
                    output.put(oPos + 1, (byte)(output.get(oPos + 1) ^ tableLine[0xFF & input.get(iPos + 1)]));
                    output.put(oPos + 2, (byte)(output.get(oPos + 2) ^ tableLine[0xFF & input.get(iPos + 2)]));
                    output.put(oPos + 3, (byte)(output.get(oPos + 3) ^ tableLine[0xFF & input.get(iPos + 3)]));
                    output.put(oPos + 4, (byte)(output.get(oPos + 4) ^ tableLine[0xFF & input.get(iPos + 4)]));
                    output.put(oPos + 5, (byte)(output.get(oPos + 5) ^ tableLine[0xFF & input.get(iPos + 5)]));
                    output.put(oPos + 6, (byte)(output.get(oPos + 6) ^ tableLine[0xFF & input.get(iPos + 6)]));
                    output.put(oPos + 7, (byte)(output.get(oPos + 7) ^ tableLine[0xFF & input.get(iPos + 7)]));
                    ++i;
                    iPos += 8;
                    oPos += 8;
                }
                i = extra;
                while (i < dataLen) {
                    output.put(oPos, (byte)(output.get(oPos) ^ tableLine[0xFF & input.get(iPos)]));
                    ++i;
                    ++iPos;
                    ++oPos;
                }
            }
        }
    }
}

