/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.ozone.shaded.org.apache.commons.lang3.StringUtils;

public enum BucketLayout {
    FILE_SYSTEM_OPTIMIZED,
    OBJECT_STORE,
    LEGACY;

    public static final BucketLayout DEFAULT;

    public static BucketLayout fromProto(OzoneManagerProtocolProtos.BucketLayoutProto bucketLayout) {
        if (bucketLayout == null) {
            return LEGACY;
        }
        switch (bucketLayout) {
            case FILE_SYSTEM_OPTIMIZED: {
                return FILE_SYSTEM_OPTIMIZED;
            }
            case LEGACY: {
                return LEGACY;
            }
            case OBJECT_STORE: {
                return OBJECT_STORE;
            }
        }
        return DEFAULT;
    }

    public OzoneManagerProtocolProtos.BucketLayoutProto toProto() {
        switch (this.ordinal()) {
            case 0: {
                return OzoneManagerProtocolProtos.BucketLayoutProto.FILE_SYSTEM_OPTIMIZED;
            }
            case 1: {
                return OzoneManagerProtocolProtos.BucketLayoutProto.OBJECT_STORE;
            }
            case 2: {
                return OzoneManagerProtocolProtos.BucketLayoutProto.LEGACY;
            }
        }
        throw new IllegalArgumentException("Error: BucketLayout not found, type=" + (Object)((Object)this));
    }

    public boolean isFileSystemOptimized() {
        return this.equals((Object)FILE_SYSTEM_OPTIMIZED);
    }

    public boolean isLegacy() {
        return this.equals((Object)LEGACY);
    }

    public boolean isObjectStore(boolean enableFileSystemPaths) {
        if (this.equals((Object)OBJECT_STORE)) {
            return true;
        }
        return this.equals((Object)LEGACY) && !enableFileSystemPaths;
    }

    public boolean shouldNormalizePaths(boolean enableFileSystemPaths) {
        switch (this.ordinal()) {
            case 1: {
                return false;
            }
            case 0: {
                return true;
            }
            case 2: {
                return enableFileSystemPaths;
            }
        }
        throw new IllegalArgumentException("Invalid Bucket Layout:" + (Object)((Object)this));
    }

    public static BucketLayout fromString(String value) {
        return StringUtils.isBlank(value) ? LEGACY : BucketLayout.valueOf(value);
    }

    public void validateSupportedOperation() throws OMException {
        if (!this.isLegacy()) {
            throw new OMException("Client is attempting to modify a bucket which uses non-LEGACY bucket layout features. Please upgrade the client to a compatible version before performing this operation.", OMException.ResultCodes.NOT_SUPPORTED_OPERATION);
        }
    }

    static {
        DEFAULT = LEGACY;
    }
}

