/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.hadoop.crypto.CryptoOutputStream;
import org.apache.hadoop.fs.Syncable;
import org.apache.hadoop.hdds.scm.storage.ByteBufferStreamOutput;
import org.apache.hadoop.ozone.client.io.ByteBufferOutputStream;
import org.apache.hadoop.ozone.client.io.CipherOutputStreamOzone;
import org.apache.hadoop.ozone.client.io.KeyDataStreamOutput;
import org.apache.hadoop.ozone.client.io.KeyMetadataAware;
import org.apache.hadoop.ozone.client.io.OzoneOutputStream;
import org.apache.hadoop.ozone.om.helpers.OmMultipartCommitUploadPartInfo;

public class OzoneDataStreamOutput
extends ByteBufferOutputStream
implements KeyMetadataAware {
    private final ByteBufferStreamOutput byteBufferStreamOutput;
    private boolean enableHsync;
    private final Syncable syncable;

    public OzoneDataStreamOutput(Syncable outputStream2, boolean enableHsync) {
        this(Optional.of(Objects.requireNonNull(outputStream2, "outputStream == null")).filter(s2 -> s2 instanceof OzoneDataStreamOutput).map(s2 -> (OzoneDataStreamOutput)s2).orElseThrow(() -> new IllegalArgumentException("The parameter syncable is not an OutputStream")), outputStream2, enableHsync);
    }

    public OzoneDataStreamOutput(ByteBufferStreamOutput byteBufferStreamOutput, Syncable syncable) {
        this(byteBufferStreamOutput, syncable, false);
    }

    public OzoneDataStreamOutput(ByteBufferStreamOutput byteBufferStreamOutput, Syncable syncable, boolean enableHsync) {
        this.byteBufferStreamOutput = Objects.requireNonNull(byteBufferStreamOutput, "byteBufferStreamOutput == null");
        this.syncable = syncable != null ? syncable : byteBufferStreamOutput;
        this.enableHsync = enableHsync;
    }

    @Override
    public void write(ByteBuffer b, int off, int len) throws IOException {
        this.byteBufferStreamOutput.write(b, off, len);
    }

    @Override
    public synchronized void flush() throws IOException {
        this.byteBufferStreamOutput.flush();
    }

    @Override
    public synchronized void close() throws IOException {
        this.byteBufferStreamOutput.close();
    }

    public OmMultipartCommitUploadPartInfo getCommitUploadPartInfo() {
        KeyDataStreamOutput keyDataStreamOutput = this.getKeyDataStreamOutput();
        if (keyDataStreamOutput != null) {
            return keyDataStreamOutput.getCommitUploadPartInfo();
        }
        return null;
    }

    public KeyDataStreamOutput getKeyDataStreamOutput() {
        if (this.byteBufferStreamOutput instanceof OzoneOutputStream) {
            OutputStream wrappedStream;
            OutputStream outputStream2 = ((OzoneOutputStream)this.byteBufferStreamOutput).getOutputStream();
            if (outputStream2 instanceof KeyDataStreamOutput) {
                return (KeyDataStreamOutput)outputStream2;
            }
            if (outputStream2 instanceof CryptoOutputStream) {
                OutputStream wrappedStream2 = ((CryptoOutputStream)outputStream2).getWrappedStream();
                if (wrappedStream2 instanceof KeyDataStreamOutput) {
                    return (KeyDataStreamOutput)wrappedStream2;
                }
            } else if (outputStream2 instanceof CipherOutputStreamOzone && (wrappedStream = ((CipherOutputStreamOzone)outputStream2).getWrappedStream()) instanceof KeyDataStreamOutput) {
                return (KeyDataStreamOutput)wrappedStream;
            }
        } else if (this.byteBufferStreamOutput instanceof KeyDataStreamOutput) {
            return (KeyDataStreamOutput)this.byteBufferStreamOutput;
        }
        return null;
    }

    public void hflush() throws IOException {
        this.hsync();
    }

    public void hsync() throws IOException {
        if (!this.enableHsync) {
            this.byteBufferStreamOutput.flush();
            return;
        }
        if (this.syncable != null) {
            if (this.byteBufferStreamOutput != this.syncable) {
                this.byteBufferStreamOutput.flush();
            }
        } else {
            throw new UnsupportedOperationException(this.byteBufferStreamOutput.getClass() + " is not " + Syncable.class.getSimpleName());
        }
        this.syncable.hsync();
    }

    public ByteBufferStreamOutput getByteBufStreamOutput() {
        return this.byteBufferStreamOutput;
    }

    @Override
    public Map<String, String> getMetadata() {
        return ((KeyMetadataAware)((Object)this.byteBufferStreamOutput)).getMetadata();
    }
}

