/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.MutableConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.utils.LeakDetector;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.protocol.ClientProtocol;
import org.apache.hadoop.ozone.client.rpc.RpcClient;
import org.apache.hadoop.ozone.security.OzoneTokenIdentifier;
import org.apache.hadoop.security.token.Token;
import org.apache.ozone.shaded.com.google.common.base.Preconditions;
import org.apache.ozone.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.ozone.shaded.org.apache.ratis.util.UncheckedAutoCloseable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OzoneClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneClientFactory.class);
    private static final LeakDetector OZONE_CLIENT_LEAK_DETECTOR = new LeakDetector("OzoneClientObject");

    private OzoneClientFactory() {
    }

    public static UncheckedAutoCloseable track(AutoCloseable object) {
        Class<?> clazz = object.getClass();
        StackTraceElement[] stackTrace = HddsUtils.getStackTrace(LOG);
        return OZONE_CLIENT_LEAK_DETECTOR.track(object, () -> HddsUtils.reportLeak(clazz, HddsUtils.formatStackTrace(stackTrace, 4), LOG));
    }

    public static OzoneClient getRpcClient() throws IOException {
        LOG.info("Creating OzoneClient with default configuration.");
        return OzoneClientFactory.getRpcClient(new OzoneConfiguration());
    }

    public static OzoneClient getRpcClient(String omHost, Integer omRpcPort, MutableConfigurationSource config) throws IOException {
        Preconditions.checkNotNull(omHost);
        Preconditions.checkNotNull(omRpcPort);
        Preconditions.checkNotNull(config);
        OmUtils.resolveOmHost(omHost, omRpcPort);
        config.set("ozone.om.address", omHost + ":" + omRpcPort);
        return OzoneClientFactory.getRpcClient(OzoneClientFactory.getClientProtocol(config), (ConfigurationSource)config);
    }

    public static OzoneClient getRpcClient(String omServiceId, ConfigurationSource config) throws IOException {
        Preconditions.checkNotNull(omServiceId);
        Preconditions.checkNotNull(config);
        if (OmUtils.isOmHAServiceId(config, omServiceId)) {
            return OzoneClientFactory.getRpcClient(OzoneClientFactory.getClientProtocol(config, omServiceId), config);
        }
        throw new IOException("Service ID specified does not match with ozone.om.service.ids defined in the configuration. Configured ozone.om.service.ids are" + config.getTrimmedStringCollection("ozone.om.service.ids"));
    }

    public static OzoneClient getRpcClient(ConfigurationSource config) throws IOException {
        Preconditions.checkNotNull(config);
        String[] serviceIds = config.getTrimmedStrings("ozone.om.service.ids");
        if (serviceIds.length > 1) {
            throw new IOException("Following ServiceID's " + config.getTrimmedStringCollection("ozone.om.service.ids") + " are defined in the configuration. Use the method getRpcClient which takes serviceID and configuration as param");
        }
        if (serviceIds.length == 1) {
            return OzoneClientFactory.getRpcClient(OzoneClientFactory.getClientProtocol(config, serviceIds[0]), config);
        }
        return OzoneClientFactory.getRpcClient(OzoneClientFactory.getClientProtocol(config), config);
    }

    private static OzoneClient getRpcClient(ClientProtocol clientProtocol, ConfigurationSource config) {
        return new OzoneClient(config, clientProtocol);
    }

    public static OzoneClient getOzoneClient(Configuration conf, Token<OzoneTokenIdentifier> token) throws IOException {
        Preconditions.checkNotNull(token, "Null token is not allowed");
        OzoneTokenIdentifier tokenId = new OzoneTokenIdentifier();
        ByteArrayInputStream buf = new ByteArrayInputStream(token.getIdentifier());
        DataInputStream in = new DataInputStream(buf);
        tokenId.readFields(in);
        String omServiceId = tokenId.getOmServiceId();
        OzoneConfiguration ozoneConf = OzoneConfiguration.of(conf);
        if (StringUtils.isNotEmpty(omServiceId)) {
            if (!OmUtils.isServiceIdsDefined(ozoneConf) && omServiceId.equals("omServiceIdDefault")) {
                return OzoneClientFactory.getRpcClient(ozoneConf);
            }
            if (OmUtils.isOmHAServiceId(ozoneConf, omServiceId)) {
                return OzoneClientFactory.getRpcClient(omServiceId, (ConfigurationSource)ozoneConf);
            }
            throw new IOException("Service ID specified " + omServiceId + " does not match with " + "ozone.om.service.ids" + " defined in the configuration. Configured " + "ozone.om.service.ids" + " are" + ozoneConf.getTrimmedStringCollection("ozone.om.service.ids"));
        }
        if (!OmUtils.isServiceIdsDefined(ozoneConf)) {
            return OzoneClientFactory.getRpcClient(ozoneConf);
        }
        throw new IOException("OzoneToken with no service ID can't be renewed or canceled with local OM HA setup because we don't know if the token is issued from local OM HA cluster or not.");
    }

    private static ClientProtocol getClientProtocol(ConfigurationSource config) throws IOException {
        return OzoneClientFactory.getClientProtocol(config, null);
    }

    private static ClientProtocol getClientProtocol(ConfigurationSource config, String omServiceId) throws IOException {
        try {
            return new RpcClient(config, omServiceId);
        }
        catch (Exception e) {
            String message = "Couldn't create RpcClient protocol";
            LOG.error("Couldn't create RpcClient protocol exception: ", (Throwable)e);
            if (e instanceof RemoteException) {
                throw ((RemoteException)e).unwrapRemoteException();
            }
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException("Couldn't create RpcClient protocol", e);
        }
    }
}

