/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.token;

import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import java.util.UUID;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.ozone.shaded.com.google.common.base.Strings;

@InterfaceAudience.Private
public abstract class ShortLivedTokenIdentifier
extends TokenIdentifier {
    private String ownerId;
    private Instant expiry;
    private UUID secretKeyId;

    public abstract String getService();

    protected ShortLivedTokenIdentifier() {
    }

    protected ShortLivedTokenIdentifier(String ownerId, Instant expiry) {
        this.ownerId = ownerId;
        this.expiry = expiry;
    }

    public UserGroupInformation getUser() {
        if (Strings.isNullOrEmpty(this.getOwnerId())) {
            return UserGroupInformation.createRemoteUser((String)this.getService());
        }
        return UserGroupInformation.createRemoteUser((String)this.ownerId);
    }

    public boolean isExpired(Instant at) {
        return this.expiry.isBefore(at);
    }

    protected void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    protected void setExpiry(Instant expiry) {
        this.expiry = expiry;
    }

    public void setSecretKeyId(UUID secretKeyId) {
        this.secretKeyId = secretKeyId;
    }

    public Instant getExpiry() {
        return this.expiry;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public UUID getSecretKeyId() {
        return this.secretKeyId;
    }

    public abstract void readFromByteArray(byte[] var1) throws IOException;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ShortLivedTokenIdentifier that = (ShortLivedTokenIdentifier)((Object)o);
        return Objects.equals(this.ownerId, that.ownerId) && Objects.equals(this.expiry, that.expiry) && Objects.equals(this.secretKeyId, that.secretKeyId);
    }

    public int hashCode() {
        return Objects.hash(this.ownerId, this.expiry, this.secretKeyId);
    }

    public String toString() {
        return "ownerId=" + this.ownerId + ", expiry=" + this.expiry + ", secretKeyId=" + this.secretKeyId;
    }
}

