/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli.container;

import java.io.IOException;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.cli.ScmSubcommand;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerWithPipeline;
import org.apache.hadoop.ozone.shell.ShellReplicationOptions;
import picocli.CommandLine;

@CommandLine.Command(name="create", description={"Create container. If no replication config provided, defaults to STAND_ALONE with replication factor ONE."}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class CreateSubcommand
extends ScmSubcommand {
    @CommandLine.Option(description={"Owner of the new container"}, defaultValue="OZONE", names={"-o", "--owner"})
    private String owner;
    @CommandLine.Mixin
    private ShellReplicationOptions containerReplicationOptions;

    @Override
    public void execute(ScmClient scmClient) throws IOException {
        ReplicationConfig replicationConfig = this.containerReplicationOptions.fromParamsOrConfig((ConfigurationSource)new OzoneConfiguration());
        if (replicationConfig == null) {
            replicationConfig = ReplicationConfig.fromProtoTypeAndFactor((HddsProtos.ReplicationType)HddsProtos.ReplicationType.STAND_ALONE, (HddsProtos.ReplicationFactor)HddsProtos.ReplicationFactor.ONE);
        }
        ContainerWithPipeline container = scmClient.createContainer(replicationConfig, this.owner);
        System.out.printf("Container %s is created with replication config %s.%n", container.getContainerInfo().getContainerID(), replicationConfig);
    }
}

