/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.ha;

import com.google.common.base.Preconditions;
import com.google.protobuf.ServiceException;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.RatisConfUtils;
import org.apache.hadoop.hdds.conf.StorageUnit;
import org.apache.hadoop.hdds.ratis.RatisHelper;
import org.apache.hadoop.hdds.ratis.ServerNotLeaderException;
import org.apache.hadoop.hdds.scm.ha.NonRetriableException;
import org.apache.hadoop.hdds.scm.ha.RetriableWithFailOverException;
import org.apache.hadoop.hdds.scm.ha.RetriableWithNoFailoverException;
import org.apache.hadoop.hdds.scm.ha.SCMHAUtils;
import org.apache.hadoop.hdds.scm.ha.SCMRatisServerImpl;
import org.apache.hadoop.hdds.security.exception.SCMSecurityException;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.grpc.GrpcConfigKeys;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.exceptions.NotLeaderException;
import org.apache.ratis.rpc.RpcType;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.TimeDuration;

public final class RatisUtil {
    private RatisUtil() {
    }

    public static RaftProperties newRaftProperties(ConfigurationSource conf) {
        RaftProperties properties = new RaftProperties();
        RatisUtil.setRaftStorageDir(properties, conf);
        int logAppenderBufferByteLimit = RatisUtil.setRaftLogProperties(properties, conf);
        RatisUtil.setRaftRpcProperties(properties, conf, logAppenderBufferByteLimit);
        RatisUtil.setRaftRetryCacheProperties(properties, conf);
        RatisUtil.setRaftSnapshotProperties(properties, conf);
        RatisUtil.setRaftLeadElectionProperties(properties, conf);
        String prefix = "raft.server.";
        conf.getPropsMatchPrefixAndTrimPrefix("ozone.scm.ha.raft.server.").forEach((k, v) -> properties.set("raft.server." + k, v));
        return properties;
    }

    public static void setRaftStorageDir(RaftProperties properties, ConfigurationSource conf) {
        RaftServerConfigKeys.setStorageDir((RaftProperties)properties, Collections.singletonList(new File(SCMHAUtils.getRatisStorageDir((ConfigurationSource)conf))));
    }

    private static void setRaftRpcProperties(RaftProperties properties, ConfigurationSource ozoneConf, int logAppenderBufferByteLimit) {
        RatisHelper.setRpcType((RaftProperties)properties, (RpcType)RpcType.valueOf((String)ozoneConf.get("ozone.scm.ha.ratis.rpc.type", "GRPC")));
        GrpcConfigKeys.Server.setPort((RaftProperties)properties, (int)ozoneConf.getInt("ozone.scm.ratis.port", 9894));
        RatisConfUtils.Grpc.setMessageSizeMax((RaftProperties)properties, (int)logAppenderBufferByteLimit);
        long ratisRequestTimeout = ozoneConf.getTimeDuration("ozone.scm.ha.ratis.request.timeout", 30000L, TimeUnit.MILLISECONDS);
        Preconditions.checkArgument((ratisRequestTimeout > 1000L ? 1 : 0) != 0, (Object)"Ratis request timeout cannot be less than 1000ms.");
        RaftServerConfigKeys.Rpc.setRequestTimeout((RaftProperties)properties, (TimeDuration)TimeDuration.valueOf((long)ratisRequestTimeout, (TimeUnit)TimeUnit.MILLISECONDS));
        RaftServerConfigKeys.Rpc.setTimeoutMin((RaftProperties)properties, (TimeDuration)TimeDuration.valueOf((long)ozoneConf.getTimeDuration("ozone.scm.ha.ratis.leader.election.timeout", 5000L, TimeUnit.MILLISECONDS), (TimeUnit)TimeUnit.MILLISECONDS));
        RaftServerConfigKeys.Rpc.setTimeoutMax((RaftProperties)properties, (TimeDuration)TimeDuration.valueOf((long)(ozoneConf.getTimeDuration("ozone.scm.ha.ratis.leader.election.timeout", 5000L, TimeUnit.MILLISECONDS) + 200L), (TimeUnit)TimeUnit.MILLISECONDS));
        RaftServerConfigKeys.Rpc.setSlownessTimeout((RaftProperties)properties, (TimeDuration)TimeDuration.valueOf((long)ozoneConf.getTimeDuration("ozone.scm.ha.ratis.server.failure.timeout.duration", 120000L, TimeUnit.MILLISECONDS), (TimeUnit)TimeUnit.MILLISECONDS));
        RatisHelper.setFirstElectionTimeoutDuration((ConfigurationSource)ozoneConf, (RaftProperties)properties, (String)"ozone.scm.ha.raft.server.rpc.first-election.timeout");
    }

    private static void setRaftLeadElectionProperties(RaftProperties properties, ConfigurationSource ozoneConf) {
        RaftServerConfigKeys.LeaderElection.setPreVote((RaftProperties)properties, (boolean)ozoneConf.getBoolean("ozone.scm.ha.ratis.server.leaderelection.pre-vote", true));
    }

    private static int setRaftLogProperties(RaftProperties properties, ConfigurationSource ozoneConf) {
        RaftServerConfigKeys.Log.setSegmentSizeMax((RaftProperties)properties, (SizeInBytes)SizeInBytes.valueOf((long)((long)ozoneConf.getStorageSize("ozone.scm.ha.ratis.segment.size", "64MB", StorageUnit.BYTES))));
        RaftServerConfigKeys.Log.Appender.setBufferElementLimit((RaftProperties)properties, (int)ozoneConf.getInt("ozone.scm.ha.ratis.log.appender.queue.num-elements", 1024));
        int logAppenderQueueByteLimit = (int)ozoneConf.getStorageSize("ozone.scm.ha.ratis.log.appender.queue.byte-limit", "32MB", StorageUnit.BYTES);
        RaftServerConfigKeys.Log.Appender.setBufferByteLimit((RaftProperties)properties, (SizeInBytes)SizeInBytes.valueOf((long)logAppenderQueueByteLimit));
        RaftServerConfigKeys.Log.setWriteBufferSize((RaftProperties)properties, (SizeInBytes)SizeInBytes.valueOf((long)(logAppenderQueueByteLimit + 8)));
        RaftServerConfigKeys.Log.setPreallocatedSize((RaftProperties)properties, (SizeInBytes)SizeInBytes.valueOf((long)((long)ozoneConf.getStorageSize("ozone.scm.ha.ratis.segment.preallocated.size", "4MB", StorageUnit.BYTES))));
        RaftServerConfigKeys.Log.Appender.setInstallSnapshotEnabled((RaftProperties)properties, (boolean)false);
        RaftServerConfigKeys.Log.setPurgeUptoSnapshotIndex((RaftProperties)properties, (boolean)ozoneConf.getBoolean("ozone.scm.ha.ratis.log.purge.enabled", false));
        RaftServerConfigKeys.Log.setPurgeGap((RaftProperties)properties, (int)ozoneConf.getInt("ozone.scm.ha.ratis.log.purge.gap", 1000000));
        RaftServerConfigKeys.Log.setSegmentCacheNumMax((RaftProperties)properties, (int)2);
        RaftServerConfigKeys.Log.setLogMetadataEnabled((RaftProperties)properties, (boolean)false);
        return logAppenderQueueByteLimit;
    }

    private static void setRaftRetryCacheProperties(RaftProperties properties, ConfigurationSource ozoneConf) {
        RaftServerConfigKeys.RetryCache.setExpiryTime((RaftProperties)properties, (TimeDuration)TimeDuration.valueOf((long)ozoneConf.getTimeDuration("ozone.scm.ha.ratis.server.retry.cache.timeout", 60000L, TimeUnit.MILLISECONDS), (TimeUnit)TimeUnit.MILLISECONDS));
    }

    private static void setRaftSnapshotProperties(RaftProperties properties, ConfigurationSource ozoneConf) {
        RaftServerConfigKeys.Snapshot.setAutoTriggerEnabled((RaftProperties)properties, (boolean)true);
        RaftServerConfigKeys.Snapshot.setAutoTriggerThreshold((RaftProperties)properties, (long)ozoneConf.getLong("ozone.scm.ha.ratis.snapshot.threshold", 1000L));
        RaftServerConfigKeys.Snapshot.setCreationGap((RaftProperties)properties, (long)ozoneConf.getLong("ozone.scm.ha.ratis.server.snapshot.creation.gap", 1024L));
    }

    public static void checkRatisException(IOException e, String port, String scmId, String hostname, String roleType) throws ServiceException {
        if (SCMHAUtils.isNonRetriableException((Exception)e)) {
            throw new ServiceException((Throwable)new NonRetriableException(e));
        }
        if (SCMHAUtils.isRetriableWithNoFailoverException((Exception)e)) {
            throw new ServiceException((Throwable)new RetriableWithNoFailoverException(e));
        }
        if (SCMHAUtils.getNotLeaderException((Exception)e) != null) {
            NotLeaderException nle = (NotLeaderException)SCMHAUtils.getNotLeaderException((Exception)e);
            throw new ServiceException((Throwable)ServerNotLeaderException.convertToNotLeaderException((NotLeaderException)nle, (RaftPeerId)SCMRatisServerImpl.getSelfPeerId(scmId), (String)port, (String)hostname, (String)roleType));
        }
        if (e instanceof SCMSecurityException) {
            SCMSecurityException ex = (SCMSecurityException)e;
            if (ex.getErrorCode().equals((Object)SCMSecurityException.ErrorCode.NOT_A_PRIMARY_SCM)) {
                throw new ServiceException((Throwable)new RetriableWithFailOverException(e));
            }
            if (ex.getErrorCode().equals((Object)SCMSecurityException.ErrorCode.GET_SCM_CERTIFICATE_FAILED) || ex.getErrorCode().equals((Object)SCMSecurityException.ErrorCode.GET_OM_CERTIFICATE_FAILED) || ex.getErrorCode().equals((Object)SCMSecurityException.ErrorCode.GET_DN_CERTIFICATE_FAILED) || ex.getErrorCode().equals((Object)SCMSecurityException.ErrorCode.GET_CERTIFICATE_FAILED)) {
                throw new ServiceException((Throwable)new RetriableWithNoFailoverException(e));
            }
        }
    }
}

