/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.placement.metrics;

import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Private
@Metrics(about="SCM Performance Metrics", context="ozone")
public final class SCMPerformanceMetrics
implements MetricsSource {
    private static final String SOURCE_NAME = SCMPerformanceMetrics.class.getSimpleName();
    private MetricsRegistry registry = new MetricsRegistry(SOURCE_NAME);
    private static SCMPerformanceMetrics instance;
    @Metric(about="Number of failed deleteKeys")
    private MutableCounterLong deleteKeyFailure;
    @Metric(about="Number of success deleteKeys")
    private MutableCounterLong deleteKeySuccess;
    @Metric(about="Latency for deleteKey failure in nanoseconds")
    private MutableRate deleteKeyFailureLatencyNs;
    @Metric(about="Latency for deleteKey success in nanoseconds")
    private MutableRate deleteKeySuccessLatencyNs;
    @Metric(about="Latency for a successful allocateBlock call in nanoseconds")
    private MutableRate allocateBlockSuccessLatencyNs;
    @Metric(about="Latency for a failed allocateBlock call in nanoseconds")
    private MutableRate allocateBlockFailureLatencyNs;
    @Metric(about="Total blocks taken in each key delete cycle.")
    private MutableCounterLong deleteKeyBlocksSuccess;
    @Metric(about="Total blocks taken in each key delete cycle failure.")
    private MutableCounterLong deleteKeyBlocksFailure;

    public static SCMPerformanceMetrics create() {
        if (instance != null) {
            return instance;
        }
        MetricsSystem ms = DefaultMetricsSystem.instance();
        instance = (SCMPerformanceMetrics)ms.register(SOURCE_NAME, "SCM Performance Metrics", (Object)new SCMPerformanceMetrics());
        return instance;
    }

    public void unRegister() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(SOURCE_NAME);
    }

    public void getMetrics(MetricsCollector collector, boolean all) {
        MetricsRecordBuilder recordBuilder = collector.addRecord(SOURCE_NAME);
        this.deleteKeySuccess.snapshot(recordBuilder, true);
        this.deleteKeySuccessLatencyNs.snapshot(recordBuilder, true);
        this.deleteKeyFailure.snapshot(recordBuilder, true);
        this.deleteKeyFailureLatencyNs.snapshot(recordBuilder, true);
        this.allocateBlockSuccessLatencyNs.snapshot(recordBuilder, true);
        this.allocateBlockFailureLatencyNs.snapshot(recordBuilder, true);
        this.deleteKeyBlocksSuccess.snapshot(recordBuilder, true);
        this.deleteKeyBlocksFailure.snapshot(recordBuilder, true);
    }

    public void updateAllocateBlockSuccessLatencyNs(long startNanos) {
        this.allocateBlockSuccessLatencyNs.add(Time.monotonicNowNanos() - startNanos);
    }

    public void updateAllocateBlockFailureLatencyNs(long startNanos) {
        this.allocateBlockFailureLatencyNs.add(Time.monotonicNowNanos() - startNanos);
    }

    public void updateDeleteKeySuccessStats(long keys, long startNanos) {
        this.deleteKeySuccess.incr(keys);
        this.deleteKeySuccessLatencyNs.add(Time.monotonicNowNanos() - startNanos);
    }

    public void updateDeleteKeyFailureStats(long keys, long startNanos) {
        this.deleteKeyFailure.incr(keys);
        this.deleteKeyFailureLatencyNs.add(Time.monotonicNowNanos() - startNanos);
    }

    public void updateDeleteKeySuccessBlocks(long keys) {
        this.deleteKeyBlocksSuccess.incr(keys);
    }

    public void updateDeleteKeyFailedBlocks(long keys) {
        this.deleteKeyBlocksFailure.incr(keys);
    }
}

