/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.upgrade;

import com.google.inject.Injector;
import javax.sql.DataSource;
import org.apache.hadoop.ozone.recon.ReconGuiceServletContextListener;
import org.apache.hadoop.ozone.recon.tasks.ReconTaskController;
import org.apache.hadoop.ozone.recon.tasks.ReconTaskReInitializationEvent;
import org.apache.hadoop.ozone.recon.upgrade.ReconLayoutFeature;
import org.apache.hadoop.ozone.recon.upgrade.ReconUpgradeAction;
import org.apache.hadoop.ozone.recon.upgrade.UpgradeActionRecon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UpgradeActionRecon(feature=ReconLayoutFeature.NSSUMMARY_AGGREGATED_TOTALS, type=ReconUpgradeAction.UpgradeActionType.FINALIZE)
public class NSSummaryAggregatedTotalsUpgrade
implements ReconUpgradeAction {
    private static final Logger LOG = LoggerFactory.getLogger(NSSummaryAggregatedTotalsUpgrade.class);

    @Override
    public void execute(DataSource source) throws Exception {
        Injector injector = ReconGuiceServletContextListener.getGlobalInjector();
        if (injector == null) {
            throw new IllegalStateException("Guice injector not initialized. NSSummary rebuild cannot proceed during upgrade.");
        }
        ReconTaskController reconTaskController = (ReconTaskController)injector.getInstance(ReconTaskController.class);
        LOG.info("Triggering asynchronous NSSummary tree rebuild for materialized totals (upgrade action).");
        ReconTaskController.ReInitializationResult result = reconTaskController.queueReInitializationEvent(ReconTaskReInitializationEvent.ReInitializationReason.MANUAL_TRIGGER);
        if (result != ReconTaskController.ReInitializationResult.SUCCESS) {
            LOG.error("Failed to queue reinitialization event for manual trigger (result: {}), failing the reinitialization during NSSummaryAggregatedTotalsUpgrade action, will be retried as part of syncDataFromOM scheduler task.", (Object)result);
        }
    }

    @Override
    public ReconUpgradeAction.UpgradeActionType getType() {
        return ReconUpgradeAction.UpgradeActionType.FINALIZE;
    }
}

