/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.spi.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.ProvisionException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.utils.db.DBDefinition;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.hdds.utils.db.DBStoreBuilder;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.recon.ReconUtils;
import org.apache.hadoop.ozone.recon.spi.impl.ReconDBDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconDBProvider {
    private static final String STAGED_EXT = ".staged";
    private static final String BACKUP_EXT = ".backup";
    private OzoneConfiguration configuration;
    private ReconUtils reconUtils;
    private DBStore dbStore;
    @VisibleForTesting
    private static final Logger LOG = LoggerFactory.getLogger(ReconDBProvider.class);

    @Inject
    ReconDBProvider(OzoneConfiguration configuration, ReconUtils reconUtils) {
        this.configuration = configuration;
        this.reconUtils = reconUtils;
        this.dbStore = this.provideReconDB();
    }

    private ReconDBProvider(OzoneConfiguration configuration, ReconUtils reconUtils, DBStore dbStore) {
        this.configuration = configuration;
        this.reconUtils = reconUtils;
        this.dbStore = dbStore;
    }

    public ReconDBProvider getStagedReconDBProvider() throws IOException {
        File reconDbDir = this.reconUtils.getReconDbDir((ConfigurationSource)this.configuration, "ozone.recon.db.dir");
        String stagedDbName = "recon-container-key.db.staged";
        FileUtils.deleteDirectory((File)new File(reconDbDir, stagedDbName));
        DBStore db = ReconDBProvider.initializeDBStore(this.configuration, stagedDbName);
        if (db == null) {
            throw new ProvisionException("Unable to initialize staged recon container DBStore");
        }
        return new ReconDBProvider(this.configuration, this.reconUtils, db);
    }

    public DBStore provideReconDB() {
        try {
            File reconDbDir = this.reconUtils.getReconDbDir((ConfigurationSource)this.configuration, "ozone.recon.db.dir");
            File lastKnownContainerKeyDb = this.reconUtils.getLastKnownDB(reconDbDir, "recon-container-key.db");
            if (lastKnownContainerKeyDb != null) {
                LOG.info("Last known Recon DB : {}", (Object)lastKnownContainerKeyDb.getAbsolutePath());
                Files.move(lastKnownContainerKeyDb.toPath(), new File(reconDbDir, "recon-container-key.db").toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            }
            if (!new File(reconDbDir, "recon-container-key.db").exists() && new File(reconDbDir, "recon-container-key.db.backup").exists()) {
                LOG.info("Recon DB backup found, restoring from backup.");
                Files.move(new File(reconDbDir, "recon-container-key.db.backup").toPath(), new File(reconDbDir, "recon-container-key.db").toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            throw new ProvisionException("Unable to recover container DB path.", (Throwable)e);
        }
        DBStore db = ReconDBProvider.initializeDBStore(this.configuration, "recon-container-key.db");
        if (db == null) {
            throw new ProvisionException("Unable to provide instance of DBStore store.");
        }
        return db;
    }

    public DBStore getDbStore() {
        return this.dbStore;
    }

    static void truncateTable(Table table) throws IOException {
        if (table == null) {
            return;
        }
        try (Table.KeyValueIterator tableIterator = table.iterator();){
            while (tableIterator.hasNext()) {
                Table.KeyValue entry = (Table.KeyValue)tableIterator.next();
                table.delete(entry.getKey());
            }
        }
    }

    private static DBStore initializeDBStore(OzoneConfiguration configuration, String dbName) {
        DBStore dbStore = null;
        try {
            dbStore = DBStoreBuilder.createDBStore((ConfigurationSource)configuration, (DBDefinition)new ReconDBDefinition(dbName));
        }
        catch (Exception ex) {
            LOG.error("Unable to initialize Recon container metadata store.", (Throwable)ex);
        }
        return dbStore;
    }

    public void close() throws Exception {
        if (this.dbStore != null) {
            this.dbStore.close();
            this.dbStore = null;
        }
    }

    public void replaceStagedDb(ReconDBProvider stagedReconDBProvider) throws Exception {
        File dbPath = this.dbStore.getDbLocation();
        File stagedDbPath = stagedReconDBProvider.getDbStore().getDbLocation();
        File backupPath = new File(dbPath.getAbsolutePath() + BACKUP_EXT);
        stagedReconDBProvider.close();
        try {
            FileUtils.deleteDirectory((File)backupPath);
            this.close();
            Files.move(dbPath.toPath(), backupPath.toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            Files.move(stagedDbPath.toPath(), dbPath.toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            this.dbStore = ReconDBProvider.initializeDBStore(this.configuration, dbPath.getName());
        }
        catch (Exception e) {
            if (this.dbStore == null) {
                Files.move(dbPath.toPath(), stagedDbPath.toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
                Files.move(backupPath.toPath(), dbPath.toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
                this.dbStore = ReconDBProvider.initializeDBStore(this.configuration, dbPath.getName());
            }
            throw e;
        }
    }
}

