/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.codec;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.IntegerCodec;
import org.apache.hadoop.hdds.utils.db.LongCodec;
import org.apache.hadoop.hdds.utils.db.ShortCodec;
import org.apache.hadoop.hdds.utils.db.StringCodec;
import org.apache.hadoop.ozone.recon.ReconConstants;
import org.apache.hadoop.ozone.recon.api.types.NSSummary;

public final class NSSummaryCodec
implements Codec<NSSummary> {
    private static final Codec<NSSummary> INSTANCE = new NSSummaryCodec();
    private final Codec<Integer> integerCodec = IntegerCodec.get();
    private final Codec<Short> shortCodec = ShortCodec.get();
    private final Codec<Long> longCodec = LongCodec.get();
    private final Codec<String> stringCodec = StringCodec.get();

    private NSSummaryCodec() {
    }

    public static Codec<NSSummary> get() {
        return INSTANCE;
    }

    public Class<NSSummary> getTypeClass() {
        return NSSummary.class;
    }

    public byte[] toPersistedFormatImpl(NSSummary object) throws IOException {
        byte[] dirName = this.stringCodec.toPersistedFormat((Object)object.getDirName());
        Set<Long> childDirs = object.getChildDir();
        int numOfChildDirs = childDirs.size();
        int resSize = (3 + ReconConstants.NUM_OF_FILE_SIZE_BINS) * 4 + (numOfChildDirs + 1) * 8 + 2 + dirName.length + 8;
        ByteArrayOutputStream out = new ByteArrayOutputStream(resSize);
        out.write(this.integerCodec.toPersistedFormat((Object)object.getNumOfFiles()));
        out.write(this.longCodec.toPersistedFormat((Object)object.getSizeOfFiles()));
        out.write(this.shortCodec.toPersistedFormat((Object)((short)ReconConstants.NUM_OF_FILE_SIZE_BINS)));
        int[] fileSizeBucket = object.getFileSizeBucket();
        for (int i = 0; i < ReconConstants.NUM_OF_FILE_SIZE_BINS; ++i) {
            out.write(this.integerCodec.toPersistedFormat((Object)fileSizeBucket[i]));
        }
        out.write(this.integerCodec.toPersistedFormat((Object)numOfChildDirs));
        for (long childDirId : childDirs) {
            out.write(this.longCodec.toPersistedFormat((Object)childDirId));
        }
        out.write(this.integerCodec.toPersistedFormat((Object)dirName.length));
        out.write(dirName);
        out.write(this.longCodec.toPersistedFormat((Object)object.getParentId()));
        return out.toByteArray();
    }

    public NSSummary fromPersistedFormatImpl(byte[] rawData) throws IOException {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(rawData));
        NSSummary res = new NSSummary();
        res.setNumOfFiles(in.readInt());
        res.setSizeOfFiles(in.readLong());
        int len = in.readShort();
        assert (len == (short)ReconConstants.NUM_OF_FILE_SIZE_BINS);
        int[] fileSizeBucket = new int[len];
        for (int i = 0; i < len; ++i) {
            fileSizeBucket[i] = in.readInt();
        }
        res.setFileSizeBucket(fileSizeBucket);
        int listSize = in.readInt();
        HashSet<Long> childDir = new HashSet<Long>();
        for (int i = 0; i < listSize; ++i) {
            childDir.add(in.readLong());
        }
        res.setChildDir(childDir);
        int strLen = in.readInt();
        if (strLen == 0) {
            return res;
        }
        byte[] buffer = new byte[strLen];
        int bytesRead = in.read(buffer);
        assert (bytesRead == strLen);
        String dirName = (String)this.stringCodec.fromPersistedFormat(buffer);
        res.setDirName(dirName);
        if (in.available() >= 8) {
            long parentId = in.readLong();
            res.setParentId(parentId);
        } else {
            res.setParentId(-1L);
        }
        return res;
    }

    public NSSummary copyObject(NSSummary object) {
        NSSummary copy = new NSSummary();
        copy.setNumOfFiles(object.getNumOfFiles());
        copy.setSizeOfFiles(object.getSizeOfFiles());
        copy.setFileSizeBucket(object.getFileSizeBucket());
        copy.setChildDir(object.getChildDir());
        copy.setDirName(object.getDirName());
        copy.setParentId(object.getParentId());
        return copy;
    }
}

