/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell;

import java.util.List;
import org.apache.hadoop.hdds.cli.GenericCli;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.shell.REPL;
import picocli.CommandLine;
import picocli.shell.jline3.PicocliCommands;

@CommandLine.Command
public abstract class Shell
extends GenericCli {
    public static final String OZONE_URI_DESCRIPTION = "Ozone URI could either be a full URI or short URI.\nFull URI should start with o3://, in case of non-HA\nclusters it should be followed by the host name and\noptionally the port number. In case of HA clusters\nthe service id should be used. Service id provides a\nlogical name for multiple hosts and it is defined\nin the property ozone.om.service.ids.\nExample of a full URI with host name and port number\nfor a key:\no3://omhostname:9862/vol1/bucket1/key1\nWith a service id for a volume:\no3://omserviceid/vol1/\nShort URI should start from the volume.\nExample of a short URI for a bucket:\nvol1/bucket1\nAny unspecified information will be identified from\nthe config files.\n";
    private String name;
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;
    @CommandLine.ArgGroup
    private ExecutionMode executionMode;

    public Shell() {
        super((CommandLine.IFactory)new PicocliCommands.PicocliCommandsFactory());
        this.getCmd().setExecutionStrategy(this::execute);
    }

    public String name() {
        return this.name;
    }

    public String prompt() {
        return this.name();
    }

    private int execute(CommandLine.ParseResult parseResult) {
        this.name = this.spec.name();
        if (parseResult.hasMatchedOption("--interactive") || parseResult.hasMatchedOption("--execute")) {
            this.spec.name("");
            this.installBatchExceptionHandler();
            new REPL(this, this.getCmd(), (PicocliCommands.PicocliCommandsFactory)this.getCmd().getFactory(), this.executionMode.command);
            return 0;
        }
        TracingUtil.initTracing((String)"shell", (ConfigurationSource)this.getOzoneConf());
        String spanName = this.spec.name() + " " + String.join((CharSequence)" ", parseResult.originalArgs());
        return (Integer)TracingUtil.executeInNewSpan((String)spanName, () -> new CommandLine.RunLast().execute(parseResult));
    }

    private void installBatchExceptionHandler() {
        if (!this.executionMode.interactive) {
            CommandLine.IExecutionExceptionHandler handler = this.getCmd().getExecutionExceptionHandler();
            this.getCmd().setExecutionExceptionHandler((ex, cli, parseResult) -> {
                try {
                    int n = handler.handleExecutionException(ex, cli, parseResult);
                    return n;
                }
                finally {
                    System.exit(-1);
                }
            });
        }
    }

    public void printError(Throwable errorArg) {
        OMException omException = null;
        if (errorArg instanceof OMException) {
            omException = (OMException)errorArg;
        } else if (errorArg.getCause() instanceof OMException) {
            omException = (OMException)errorArg.getCause();
        }
        if (omException != null && !this.isVerbose()) {
            this.err().println(String.format("%s %s", omException.getResult().name(), omException.getMessage()));
        } else {
            super.printError(errorArg);
        }
    }

    private static class ExecutionMode {
        @CommandLine.Option(names={"--interactive"}, description={"Run in interactive mode"})
        private boolean interactive;
        @CommandLine.Option(names={"--execute"}, description={"Run command as part of batch"})
        private List<String> command;

        private ExecutionMode() {
        }
    }
}

