/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.server.events;

import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;

@Metrics(about="Executor Metrics", context="EventQueue")
public class EventExecutorMetrics
implements MetricsSource {
    private final String name;
    private final String description;
    private final MetricsRegistry registry;
    @Metric(value={"Number of tasks queued"})
    private MutableCounterLong queued;
    @Metric(value={"Number of tasks scheduled"})
    private MutableCounterLong scheduled;
    @Metric(value={"Number of tasks completed"})
    private MutableCounterLong done;
    @Metric(value={"Number of tasks failed"})
    private MutableCounterLong failed;
    @Metric(value={"Number of tasks dropped"})
    private MutableCounterLong dropped;
    @Metric(value={"Number of tasks with long execution time"})
    private MutableCounterLong longExecution;
    @Metric(value={"Number of tasks with long wait time in queue"})
    private MutableCounterLong longWaitInQueue;

    public EventExecutorMetrics(String name, String description) {
        this.name = name;
        this.description = description;
        this.registry = new MetricsRegistry(name);
        this.init();
    }

    public void init() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.register(this.name, this.description, (Object)this);
    }

    public void unregister() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(this.name);
    }

    public void getMetrics(MetricsCollector collector, boolean all) {
        MetricsRecordBuilder builder = collector.addRecord(this.name);
        this.registry.snapshot(builder, all);
    }

    public void incrementQueued() {
        this.queued.incr();
    }

    public void incrementScheduled() {
        this.scheduled.incr();
    }

    public void incrementDone() {
        this.done.incr();
    }

    public void incrementFailed() {
        this.failed.incr();
    }

    public void incrementDropped() {
        this.dropped.incr();
    }

    public void incrementDropped(int count) {
        this.dropped.incr((long)count);
    }

    public void incrementLongExecution() {
        this.longExecution.incr();
    }

    public void incrementLongWaitInQueue() {
        this.longWaitInQueue.incr();
    }

    public long getQueued() {
        return this.queued.value();
    }

    public long getScheduled() {
        return this.scheduled.value();
    }

    public long getDone() {
        return this.done.value();
    }

    public long getFailed() {
        return this.failed.value();
    }

    public long getDropped() {
        return this.dropped.value();
    }

    public long getLongExecution() {
        return this.longExecution.value();
    }

    public long getLongWaitInQueue() {
        return this.longWaitInQueue.value();
    }
}

