/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.debug.audit.parser.model;

public class AuditEntry {
    private String timestamp;
    private String level;
    private String logger;
    private String user;
    private String ip;
    private String op;
    private String params;
    private String result;
    private String exception;

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public String getLevel() {
        return this.level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public String getLogger() {
        return this.logger;
    }

    public void setLogger(String logger) {
        this.logger = logger;
    }

    public String getOp() {
        return this.op;
    }

    public void setOp(String op) {
        this.op = op;
    }

    public String getParams() {
        return this.params;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String getException() {
        return this.exception;
    }

    public void setException(String exception) {
        this.exception = exception.trim();
    }

    public void appendException(String text) {
        this.exception = this.exception + "\n" + text.trim();
    }

    public static class Builder {
        private String timestamp;
        private String level;
        private String logger;
        private String user;
        private String ip;
        private String op;
        private String params;
        private String result;
        private String exception;

        public Builder setTimestamp(String ts) {
            this.timestamp = ts;
            return this;
        }

        public Builder setLevel(String lvl) {
            this.level = lvl;
            return this;
        }

        public Builder setLogger(String lgr) {
            this.logger = lgr;
            return this;
        }

        public Builder setUser(String usr) {
            this.user = usr;
            return this;
        }

        public Builder setIp(String ipAddress) {
            this.ip = ipAddress;
            return this;
        }

        public Builder setOp(String operation) {
            this.op = operation;
            return this;
        }

        public Builder setParams(String prms) {
            this.params = prms;
            return this;
        }

        public Builder setResult(String res) {
            this.result = res;
            return this;
        }

        public Builder setException(String exp) {
            this.exception = exp;
            return this;
        }

        public AuditEntry build() {
            AuditEntry aentry = new AuditEntry();
            aentry.timestamp = this.timestamp;
            aentry.level = this.level;
            aentry.logger = this.logger;
            aentry.user = this.user;
            aentry.ip = this.ip;
            aentry.op = this.op;
            aentry.params = this.params;
            aentry.result = this.result;
            aentry.exception = this.exception;
            return aentry;
        }
    }
}

