/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.cli.GenericCli;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.MutableConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.ratis.RatisHelper;
import org.apache.hadoop.hdds.server.http.BaseHttpServer;
import org.apache.hadoop.hdds.server.http.HttpServer2;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.hdds.utils.VersionInfo;
import org.apache.hadoop.ozone.OzoneSecurityUtil;
import org.apache.hadoop.ozone.s3.OzoneConfigurationHolder;
import org.apache.hadoop.ozone.s3.S3GatewayHttpServer;
import org.apache.hadoop.ozone.s3.S3GatewayWebAdminServer;
import org.apache.hadoop.ozone.s3.metrics.S3GatewayMetrics;
import org.apache.hadoop.ozone.util.OzoneNetUtils;
import org.apache.hadoop.ozone.util.OzoneVersionInfo;
import org.apache.hadoop.ozone.util.ShutdownHookManager;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.ratis.util.JvmPauseMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="ozone s3g", hidden=true, description={"S3 compatible rest server."}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true)
public class Gateway
extends GenericCli
implements Callable<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(Gateway.class);
    private S3GatewayHttpServer httpServer;
    private BaseHttpServer contentServer;
    private S3GatewayMetrics metrics;
    private final JvmPauseMonitor jvmPauseMonitor = RatisHelper.newJvmPauseMonitor((String)"S3G");

    public static void main(String[] args) throws Exception {
        OzoneNetUtils.disableJvmNetworkAddressCacheIfRequired((OzoneConfiguration)new OzoneConfiguration());
        new Gateway().run(args);
    }

    @Override
    public Void call() throws Exception {
        OzoneConfiguration ozoneConfiguration = this.getOzoneConf();
        OzoneConfigurationHolder.setConfiguration(ozoneConfiguration);
        TracingUtil.initTracing((String)"S3gateway", (ConfigurationSource)OzoneConfigurationHolder.configuration());
        UserGroupInformation.setConfiguration((Configuration)OzoneConfigurationHolder.configuration());
        Gateway.loginS3GUser(OzoneConfigurationHolder.configuration());
        HttpServer2.setHttpBaseDir((OzoneConfiguration)OzoneConfigurationHolder.configuration());
        this.httpServer = new S3GatewayHttpServer((MutableConfigurationSource)OzoneConfigurationHolder.configuration(), "s3gateway");
        this.contentServer = new S3GatewayWebAdminServer((MutableConfigurationSource)OzoneConfigurationHolder.configuration(), "s3g-web");
        this.metrics = S3GatewayMetrics.create(OzoneConfigurationHolder.configuration());
        this.start();
        ShutdownHookManager.get().addShutdownHook(() -> {
            try {
                this.stop();
            }
            catch (Exception e) {
                LOG.error("Error during stop S3Gateway", (Throwable)e);
            }
        }, 10);
        return null;
    }

    public void start() throws IOException {
        String[] originalArgs = this.getCmd().getParseResult().originalArgs().toArray(new String[0]);
        HddsServerUtil.startupShutdownMessage((VersionInfo)OzoneVersionInfo.OZONE_VERSION_INFO, Gateway.class, (String[])originalArgs, (Logger)LOG, (OzoneConfiguration)OzoneConfigurationHolder.configuration());
        LOG.info("Starting Ozone S3 gateway");
        HddsServerUtil.initializeMetrics((OzoneConfiguration)OzoneConfigurationHolder.configuration(), (String)"S3Gateway");
        this.jvmPauseMonitor.start();
        this.httpServer.start();
        this.contentServer.start();
    }

    public void stop() throws Exception {
        LOG.info("Stopping Ozone S3 gateway");
        this.httpServer.stop();
        this.contentServer.stop();
        this.jvmPauseMonitor.stop();
        S3GatewayMetrics.unRegister();
    }

    private static void loginS3GUser(OzoneConfiguration conf) throws IOException, AuthenticationException {
        if (OzoneSecurityUtil.isSecurityEnabled((ConfigurationSource)conf)) {
            if (SecurityUtil.getAuthenticationMethod((Configuration)conf).equals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Ozone security is enabled. Attempting login for S3G user. Principal: {}, keytab: {}", (Object)conf.get("ozone.s3g.kerberos.principal"), (Object)conf.get("ozone.s3g.kerberos.keytab.file"));
                }
            } else {
                throw new AuthenticationException(SecurityUtil.getAuthenticationMethod((Configuration)conf) + " authentication method not supported. S3G user login failed.");
            }
            SecurityUtil.login((Configuration)conf, (String)"ozone.s3g.kerberos.keytab.file", (String)"ozone.s3g.kerberos.principal");
            LOG.info("S3Gateway login successful.");
        }
    }

    @VisibleForTesting
    public InetSocketAddress getHttpAddress() {
        return this.httpServer.getHttpAddress();
    }

    @VisibleForTesting
    public InetSocketAddress getHttpsAddress() {
        return this.httpServer.getHttpsAddress();
    }
}

