/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.org.bouncycastle.crypto.generators;

import java.security.SecureRandom;
import org.apache.ozone.shaded.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.apache.ozone.shaded.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.apache.ozone.shaded.org.bouncycastle.crypto.CryptoServicePurpose;
import org.apache.ozone.shaded.org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.apache.ozone.shaded.org.bouncycastle.crypto.KeyGenerationParameters;
import org.apache.ozone.shaded.org.bouncycastle.crypto.constraints.DefaultServiceProperties;
import org.apache.ozone.shaded.org.bouncycastle.crypto.params.Ed448PrivateKeyParameters;
import org.apache.ozone.shaded.org.bouncycastle.crypto.params.Ed448PublicKeyParameters;

public class Ed448KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SecureRandom random;

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.random = keyGenerationParameters.getRandom();
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties("Ed448KeyGen", 224, null, CryptoServicePurpose.KEYGEN));
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        Ed448PrivateKeyParameters ed448PrivateKeyParameters = new Ed448PrivateKeyParameters(this.random);
        Ed448PublicKeyParameters ed448PublicKeyParameters = ed448PrivateKeyParameters.generatePublicKey();
        return new AsymmetricCipherKeyPair(ed448PublicKeyParameters, ed448PrivateKeyParameters);
    }
}

