/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.org.apache.ratis.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.LongUnaryOperator;
import java.util.stream.Stream;
import org.apache.ozone.shaded.org.apache.ratis.util.CollectionUtils;
import org.apache.ozone.shaded.org.apache.ratis.util.JavaUtils;
import org.apache.ozone.shaded.org.apache.ratis.util.StringUtils;
import org.apache.ozone.shaded.org.apache.ratis.util.Timestamp;
import org.apache.ozone.shaded.org.apache.ratis.util.function.CheckedBiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TimeDuration
implements Comparable<TimeDuration> {
    static final Logger LOG = LoggerFactory.getLogger(TimeDuration.class);
    public static final TimeDuration ZERO = TimeDuration.valueOf(0L, TimeUnit.NANOSECONDS);
    public static final TimeDuration ONE_MILLISECOND = TimeDuration.valueOf(1L, TimeUnit.MILLISECONDS);
    public static final TimeDuration ONE_SECOND = TimeDuration.valueOf(1L, TimeUnit.SECONDS);
    public static final TimeDuration ONE_MINUTE = TimeDuration.valueOf(1L, TimeUnit.MINUTES);
    public static final TimeDuration ONE_DAY = TimeDuration.valueOf(1L, TimeUnit.DAYS);
    static final double ERROR_THRESHOLD = 0.001;
    private final long duration;
    private final TimeUnit unit;

    public static TimeUnit lowerUnit(TimeUnit unit) {
        int ordinal = unit.ordinal();
        return ordinal == 0 ? unit : TimeUnit.values()[ordinal - 1];
    }

    public static TimeUnit higherUnit(TimeUnit unit) {
        TimeUnit[] timeUnits;
        int ordinal = unit.ordinal();
        return ordinal == (timeUnits = TimeUnit.values()).length - 1 ? unit : timeUnits[ordinal + 1];
    }

    public static TimeDuration min(TimeDuration left, TimeDuration right) {
        Objects.requireNonNull(left, "left == null");
        Objects.requireNonNull(right, "right == null");
        return Stream.of(left, right).min(TimeDuration::compareTo).orElseThrow(() -> new IllegalStateException("Failed to compute min(" + left + ", " + right + ")"));
    }

    public static TimeDuration max(TimeDuration left, TimeDuration right) {
        Objects.requireNonNull(left, "left == null");
        Objects.requireNonNull(right, "right == null");
        return Stream.of(left, right).max(TimeDuration::compareTo).orElseThrow(() -> new IllegalStateException("Failed to compute max(" + left + ", " + right + ")"));
    }

    public static long parse(String timeString, TimeUnit targetUnit) {
        return TimeDuration.valueOf(timeString, targetUnit).toLong(targetUnit);
    }

    public static TimeDuration valueOf(String timeString, TimeUnit defaultUnit) {
        Objects.requireNonNull(timeString, "timeString == null");
        String lower = timeString.trim().replace("_", "").toLowerCase();
        for (Abbreviation a : Abbreviation.values()) {
            for (String s2 : a.getSymbols()) {
                if (!lower.endsWith(s2)) continue;
                String value = lower.substring(0, lower.length() - s2.length()).trim();
                try {
                    return TimeDuration.valueOf(Long.parseLong(value), a.unit());
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
        }
        Objects.requireNonNull(defaultUnit, "defaultUnit == null");
        return TimeDuration.valueOf(Long.parseLong(lower), defaultUnit);
    }

    public static TimeDuration valueOf(long duration, TimeUnit unit) {
        return new TimeDuration(duration, unit);
    }

    private TimeDuration(long duration, TimeUnit unit) {
        this.duration = duration;
        this.unit = Objects.requireNonNull(unit, "unit == null");
    }

    public long getDuration() {
        return this.duration;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public long toLong(TimeUnit targetUnit) {
        return targetUnit.convert(this.duration, this.unit);
    }

    public int toIntExact(TimeUnit targetUnit) {
        return Math.toIntExact(this.toLong(targetUnit));
    }

    public TimeDuration to(TimeUnit targetUnit) {
        if (this.unit == targetUnit) {
            return this;
        }
        TimeDuration t2 = TimeDuration.valueOf(this.toLong(targetUnit), targetUnit);
        LOG.debug("{}.to({}) = {}", new Object[]{this, targetUnit, t2});
        return t2;
    }

    public TimeDuration add(TimeDuration that) {
        Objects.requireNonNull(that, "that == null");
        TimeUnit minUnit = CollectionUtils.min(this.unit, that.unit);
        return TimeDuration.valueOf(this.toLong(minUnit) + that.toLong(minUnit), minUnit);
    }

    public TimeDuration add(long thatDuration, TimeUnit thatUnit) {
        return this.add(TimeDuration.valueOf(thatDuration, thatUnit));
    }

    public TimeDuration subtract(TimeDuration that) {
        Objects.requireNonNull(that, "that == null");
        TimeUnit minUnit = CollectionUtils.min(this.unit, that.unit);
        return TimeDuration.valueOf(this.toLong(minUnit) - that.toLong(minUnit), minUnit);
    }

    private static boolean isMagnitudeLarge(long n) {
        return n > 1000000000000L || n < -1000000000000L;
    }

    public TimeDuration multiply(double multiplier) {
        double product = (double)this.duration * multiplier;
        long rounded = Math.round(product);
        if (this.unit.ordinal() != TimeUnit.values().length - 1 && (rounded == Long.MAX_VALUE || rounded == Long.MIN_VALUE)) {
            if (Math.abs(multiplier) > 2.0) {
                return this.multiply(2.0).multiply(multiplier / 2.0);
            }
            return this.to(TimeDuration.higherUnit(this.unit)).multiply(multiplier);
        }
        if (this.unit.ordinal() != 0 && Math.abs(product - (double)rounded) > Math.abs(product) * 0.001) {
            if (TimeDuration.isMagnitudeLarge(this.duration) && Math.abs(multiplier) < 0.5) {
                return this.multiply(0.5).multiply(multiplier * 2.0);
            }
            return this.to(TimeDuration.lowerUnit(this.unit)).multiply(multiplier);
        }
        TimeDuration t2 = TimeDuration.valueOf(rounded, this.unit);
        LOG.debug("{} * {} = {}", new Object[]{this, multiplier, t2});
        return t2;
    }

    public TimeDuration negate() {
        if (this.duration == Long.MIN_VALUE) {
            return TimeDuration.valueOf(Long.MAX_VALUE, this.unit);
        }
        return TimeDuration.valueOf(Math.negateExact(this.duration), this.unit);
    }

    public long roundUpNanos(long nanos) {
        if (this.duration <= 0L) {
            throw new ArithmeticException("Rounding up to a non-positive " + JavaUtils.getClassSimpleName(this.getClass()) + " (=" + this + ")");
        }
        long divisor = this.toLong(TimeUnit.NANOSECONDS);
        if (nanos == 0L || divisor == 1L) {
            return nanos;
        }
        long remainder = nanos % divisor;
        if (remainder > 0L) {
            remainder -= divisor;
        }
        return nanos - remainder;
    }

    public TimeDuration apply(LongUnaryOperator operator) {
        return TimeDuration.valueOf(operator.applyAsLong(this.duration), this.unit);
    }

    public <OUTPUT, THROWABLE extends Throwable> OUTPUT apply(CheckedBiFunction<Long, TimeUnit, OUTPUT, THROWABLE> function) throws THROWABLE {
        return function.apply(this.getDuration(), this.getUnit());
    }

    public boolean isNegative() {
        return this.duration < 0L;
    }

    public boolean isNonNegative() {
        return this.duration >= 0L;
    }

    public boolean isPositive() {
        return this.duration > 0L;
    }

    public boolean isNonPositive() {
        return this.duration <= 0L;
    }

    public TimeDuration sleep() throws InterruptedException {
        return this.sleep(null);
    }

    public TimeDuration sleep(Consumer<Object> log) throws InterruptedException {
        if (log != null) {
            log.accept(StringUtils.stringSupplierAsObject(() -> "Start sleeping " + this));
        }
        Timestamp start = Timestamp.currentTime();
        try {
            this.unit.sleep(this.duration);
            if (log != null) {
                log.accept(StringUtils.stringSupplierAsObject(() -> "Completed sleeping " + this));
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            if (log != null) {
                log.accept(StringUtils.stringSupplierAsObject(() -> "Interrupted sleeping " + this));
            }
            throw ie;
        }
        return start.elapsedTime().subtract(this);
    }

    @Override
    public int compareTo(TimeDuration that) {
        if (this.unit.compareTo(that.unit) > 0) {
            return Integer.compare(0, that.compareTo(this));
        }
        if (this.unit == that.unit) {
            return Long.compare(this.duration, that.duration);
        }
        long thisDurationInThatUnit = this.toLong(that.unit);
        if (thisDurationInThatUnit == that.duration) {
            long thatDurationInThisUnit = that.toLong(this.unit);
            return Long.compare(this.duration, thatDurationInThisUnit);
        }
        return Long.compare(thisDurationInThatUnit, that.duration);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TimeDuration)) {
            return false;
        }
        TimeDuration that = (TimeDuration)obj;
        return this.compareTo(that) == 0;
    }

    public int hashCode() {
        return Long.hashCode(this.toLong(TimeUnit.NANOSECONDS));
    }

    public String toString() {
        return this.duration + Abbreviation.valueOf(this.unit).getDefault();
    }

    public String toString(TimeUnit targetUnit, int decimalPlaces) {
        Objects.requireNonNull(targetUnit, "targetUnit == null");
        if (targetUnit.compareTo(this.unit) <= 0) {
            return this.to(targetUnit).toString();
        }
        double divisor = this.unit.convert(1L, targetUnit);
        if ((double)this.duration % divisor == 0.0) {
            return this.to(targetUnit).toString();
        }
        String decimal = StringUtils.format("%." + decimalPlaces + "f", (double)this.duration / divisor);
        String s2 = decimal + Abbreviation.valueOf(targetUnit).getDefault();
        LOG.debug("{}.to({}) = {}", new Object[]{this, targetUnit, s2});
        return s2;
    }

    public static enum Abbreviation {
        NANOSECONDS("ns", "nanos"),
        MICROSECONDS("\u03bcs", "us", "micros"),
        MILLISECONDS("ms", "msec", "millis"),
        SECONDS("s", "sec"),
        MINUTES("min", "m"),
        HOURS("hr", "h"),
        DAYS("day", "d");

        private final TimeUnit unit = TimeUnit.valueOf(this.name());
        private final List<String> symbols;

        private Abbreviation(String ... symbols) {
            List<String> input = Arrays.asList(symbols);
            ArrayList<String> all = new ArrayList<String>(input.size() + 2);
            input.forEach(s2 -> all.add(s2.toLowerCase()));
            String s3 = this.unit.name().toLowerCase();
            Abbreviation.addIfAbsent(all, s3);
            Abbreviation.addIfAbsent(all, s3.substring(0, s3.length() - 1));
            this.symbols = Collections.unmodifiableList(all);
        }

        static void addIfAbsent(List<String> list, String toAdd) {
            for (String s2 : list) {
                if (!toAdd.equals(s2)) continue;
                return;
            }
            list.add(toAdd);
        }

        public TimeUnit unit() {
            return this.unit;
        }

        String getDefault() {
            return this.symbols.get(0);
        }

        public List<String> getSymbols() {
            return this.symbols;
        }

        public static Abbreviation valueOf(TimeUnit unit) {
            return Abbreviation.valueOf(unit.name());
        }
    }
}

