/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.handler.codec.http.websocketx;

import java.util.concurrent.TimeUnit;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.channel.ChannelFuture;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.channel.ChannelFutureListener;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.channel.ChannelHandlerContext;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.channel.ChannelPipeline;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.channel.ChannelPromise;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.handler.codec.http.HttpHeaderNames;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.handler.codec.http.HttpObject;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.handler.codec.http.HttpRequest;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.handler.codec.http.HttpResponse;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.handler.codec.http.HttpUtil;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.handler.codec.http.websocketx.WebSocketServerHandshakeException;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.handler.codec.http.websocketx.WebSocketServerProtocolConfig;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.handler.ssl.SslHandler;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.util.ReferenceCountUtil;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.util.concurrent.Future;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.util.concurrent.FutureListener;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.util.concurrent.GenericFutureListener;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.util.concurrent.ScheduledFuture;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.util.internal.ObjectUtil;

class WebSocketServerProtocolHandshakeHandler
extends ChannelInboundHandlerAdapter {
    private final WebSocketServerProtocolConfig serverConfig;
    private ChannelHandlerContext ctx;
    private ChannelPromise handshakePromise;
    private boolean isWebSocketPath;

    WebSocketServerProtocolHandshakeHandler(WebSocketServerProtocolConfig serverConfig) {
        this.serverConfig = ObjectUtil.checkNotNull(serverConfig, "serverConfig");
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) {
        this.ctx = ctx;
        this.handshakePromise = ctx.newPromise();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelRead(final ChannelHandlerContext ctx, Object msg) throws Exception {
        HttpObject httpObject = (HttpObject)msg;
        if (httpObject instanceof HttpRequest) {
            final HttpRequest req = (HttpRequest)httpObject;
            this.isWebSocketPath = this.isWebSocketPath(req);
            if (!this.isWebSocketPath) {
                ctx.fireChannelRead(msg);
                return;
            }
            try {
                WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(WebSocketServerProtocolHandshakeHandler.getWebSocketLocation(ctx.pipeline(), req, this.serverConfig.websocketPath()), this.serverConfig.subprotocols(), this.serverConfig.decoderConfig());
                final WebSocketServerHandshaker handshaker = wsFactory.newHandshaker(req);
                final ChannelPromise localHandshakePromise = this.handshakePromise;
                if (handshaker == null) {
                    WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse(ctx.channel());
                }
                WebSocketServerProtocolHandler.setHandshaker(ctx.channel(), handshaker);
                ctx.pipeline().remove(this);
                ChannelFuture handshakeFuture = handshaker.handshake(ctx.channel(), req);
                handshakeFuture.addListener(new ChannelFutureListener(){

                    @Override
                    public void operationComplete(ChannelFuture future) {
                        if (!future.isSuccess()) {
                            localHandshakePromise.tryFailure(future.cause());
                            ctx.fireExceptionCaught(future.cause());
                        } else {
                            localHandshakePromise.trySuccess();
                            ctx.fireUserEventTriggered((Object)WebSocketServerProtocolHandler.ServerHandshakeStateEvent.HANDSHAKE_COMPLETE);
                            ctx.fireUserEventTriggered(new WebSocketServerProtocolHandler.HandshakeComplete(req.uri(), req.headers(), handshaker.selectedSubprotocol()));
                        }
                    }
                });
                this.applyHandshakeTimeout();
            }
            finally {
                ReferenceCountUtil.release(req);
            }
        } else if (!this.isWebSocketPath) {
            ctx.fireChannelRead(msg);
        } else {
            ReferenceCountUtil.release(msg);
        }
    }

    private boolean isWebSocketPath(HttpRequest req) {
        String websocketPath = this.serverConfig.websocketPath();
        String uri = req.uri();
        return this.serverConfig.checkStartsWith() ? uri.startsWith(websocketPath) && ("/".equals(websocketPath) || this.checkNextUri(uri, websocketPath)) : uri.equals(websocketPath);
    }

    private boolean checkNextUri(String uri, String websocketPath) {
        int len = websocketPath.length();
        if (uri.length() > len) {
            char nextUri = uri.charAt(len);
            return nextUri == '/' || nextUri == '?';
        }
        return true;
    }

    private static void sendHttpResponse(ChannelHandlerContext ctx, HttpRequest req, HttpResponse res) {
        ChannelFuture f = ctx.writeAndFlush(res);
        if (!HttpUtil.isKeepAlive(req) || res.status().code() != 200) {
            f.addListener(ChannelFutureListener.CLOSE);
        }
    }

    private static String getWebSocketLocation(ChannelPipeline cp, HttpRequest req, String path) {
        String protocol = "ws";
        if (cp.get(SslHandler.class) != null) {
            protocol = "wss";
        }
        String host = req.headers().get(HttpHeaderNames.HOST);
        return protocol + "://" + host + path;
    }

    private void applyHandshakeTimeout() {
        final ChannelPromise localHandshakePromise = this.handshakePromise;
        long handshakeTimeoutMillis = this.serverConfig.handshakeTimeoutMillis();
        if (handshakeTimeoutMillis <= 0L || localHandshakePromise.isDone()) {
            return;
        }
        final ScheduledFuture<?> timeoutFuture = this.ctx.executor().schedule(new Runnable(){

            @Override
            public void run() {
                if (!localHandshakePromise.isDone() && localHandshakePromise.tryFailure(new WebSocketServerHandshakeException("handshake timed out"))) {
                    WebSocketServerProtocolHandshakeHandler.this.ctx.flush().fireUserEventTriggered((Object)WebSocketServerProtocolHandler.ServerHandshakeStateEvent.HANDSHAKE_TIMEOUT).close();
                }
            }
        }, handshakeTimeoutMillis, TimeUnit.MILLISECONDS);
        localHandshakePromise.addListener((GenericFutureListener<? extends Future<? super Void>>)new FutureListener<Void>(){

            @Override
            public void operationComplete(Future<Void> f) {
                timeoutFuture.cancel(false);
            }
        });
    }
}

