/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.org.apache.ratis.server.protocol;

import java.util.Comparator;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.ozone.shaded.org.apache.ratis.proto.RaftProtos;
import org.apache.ozone.shaded.org.apache.ratis.util.BiWeakValueCache;
import org.apache.ozone.shaded.org.apache.ratis.util.MemoizedSupplier;

public interface TermIndex
extends Comparable<TermIndex> {
    public static final TermIndex INITIAL_VALUE = TermIndex.valueOf(0L, -1L);
    public static final TermIndex PROTO_DEFAULT = TermIndex.valueOf(RaftProtos.TermIndexProto.getDefaultInstance());
    public static final TermIndex[] EMPTY_ARRAY = new TermIndex[0];

    public long getTerm();

    public long getIndex();

    default public RaftProtos.TermIndexProto toProto() {
        return RaftProtos.TermIndexProto.newBuilder().setTerm(this.getTerm()).setIndex(this.getIndex()).build();
    }

    @Override
    default public int compareTo(TermIndex that) {
        return Comparator.comparingLong(TermIndex::getTerm).thenComparingLong(TermIndex::getIndex).compare(this, that);
    }

    public static TermIndex valueOf(RaftProtos.TermIndexProto proto) {
        return Optional.ofNullable(proto).map(p -> TermIndex.valueOf(p.getTerm(), p.getIndex())).orElse(null);
    }

    public static TermIndex valueOf(RaftProtos.LogEntryProto proto) {
        return Optional.ofNullable(proto).map(p -> TermIndex.valueOf(p.getTerm(), p.getIndex())).orElse(null);
    }

    public static TermIndex valueOf(long term, long index) {
        return Impl.getCache().getOrCreate(term, index);
    }

    public static final class Impl {
        private static final BiWeakValueCache<Long, Long, TermIndex> CACHE = new BiWeakValueCache<Long, Long, TermIndex>("term", "index", Impl::newTermIndex);

        private Impl() {
        }

        static BiWeakValueCache<Long, Long, TermIndex> getCache() {
            return CACHE;
        }

        private static TermIndex newTermIndex(final long term, final long index) {
            return new TermIndex(){
                private final Supplier<RaftProtos.TermIndexProto> protoSupplier = MemoizedSupplier.valueOf(() -> TermIndex.super.toProto());

                @Override
                public long getTerm() {
                    return term;
                }

                @Override
                public long getIndex() {
                    return index;
                }

                public boolean equals(Object obj) {
                    if (obj == this) {
                        return true;
                    }
                    if (!(obj instanceof TermIndex)) {
                        return false;
                    }
                    TermIndex that = (TermIndex)obj;
                    return this.getTerm() == that.getTerm() && this.getIndex() == that.getIndex();
                }

                public int hashCode() {
                    return Long.hashCode(term) ^ Long.hashCode(index);
                }

                @Override
                public RaftProtos.TermIndexProto toProto() {
                    return this.protoSupplier.get();
                }

                private String longToString(long n) {
                    return n >= 0L ? String.valueOf(n) : "~";
                }

                public String toString() {
                    if (this.equals(INITIAL_VALUE)) {
                        return "<INITIAL_VALUE>";
                    }
                    if (this.equals(PROTO_DEFAULT)) {
                        return "<PROTO_DEFAULT>";
                    }
                    return String.format("(t:%s, i:%s)", this.longToString(term), this.longToString(index));
                }
            };
        }
    }
}

