/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.org.apache.ratis.retry;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import org.apache.ozone.shaded.org.apache.ratis.retry.RetryPolicy;
import org.apache.ozone.shaded.org.apache.ratis.util.JavaUtils;
import org.apache.ozone.shaded.org.apache.ratis.util.Preconditions;

public final class ExceptionDependentRetry
implements RetryPolicy {
    private final RetryPolicy defaultPolicy;
    private final Map<String, RetryPolicy> exceptionNameToPolicyMap;
    private final int maxAttempts;
    private final Supplier<String> toStringSupplier;

    public static Builder newBuilder() {
        return new Builder();
    }

    private ExceptionDependentRetry(RetryPolicy defaultPolicy, Map<String, RetryPolicy> policyMap, int maxAttempts) {
        Preconditions.assertTrue(defaultPolicy != null, "Default Policy should not be null");
        this.defaultPolicy = defaultPolicy;
        this.exceptionNameToPolicyMap = Collections.unmodifiableMap(policyMap);
        this.maxAttempts = maxAttempts;
        this.toStringSupplier = JavaUtils.memoize(() -> {
            StringBuilder b = new StringBuilder(JavaUtils.getClassSimpleName(this.getClass())).append("(").append("maxAttempts=").append(maxAttempts).append("; ").append("defaultPolicy=").append(defaultPolicy).append("; ").append("map={");
            policyMap.forEach((key, value) -> b.append((String)key).append("->").append(value).append(", "));
            b.setLength(b.length() - 2);
            return b.append("})").toString();
        });
    }

    @Override
    public RetryPolicy.Action handleAttemptFailure(RetryPolicy.Event event) {
        RetryPolicy policy = null;
        if (event.getCause() != null) {
            policy = this.exceptionNameToPolicyMap.get(event.getCause().getClass().getName());
        }
        if (policy == null) {
            policy = this.defaultPolicy;
        }
        return event.getAttemptCount() < this.maxAttempts ? policy.handleAttemptFailure(event::getCauseCount) : NO_RETRY_ACTION;
    }

    public String toString() {
        return this.toStringSupplier.get();
    }

    public static class Builder {
        private RetryPolicy defaultPolicy;
        private final Map<String, RetryPolicy> exceptionNameToPolicyMap = new TreeMap<String, RetryPolicy>();
        private int maxAttempts = Integer.MAX_VALUE;

        public Builder setExceptionToPolicy(Class<? extends Throwable> exception, RetryPolicy retryPolicy) {
            Preconditions.assertTrue(retryPolicy != null, "Exception to policy should not be null");
            RetryPolicy previous = this.exceptionNameToPolicyMap.put(exception.getName(), retryPolicy);
            Preconditions.assertNull((Object)previous, () -> "The exception " + exception + " is already set to " + previous);
            return this;
        }

        public Builder setDefaultPolicy(RetryPolicy retryPolicy) {
            Preconditions.assertTrue(retryPolicy != null, "Default Policy should not be null");
            this.defaultPolicy = retryPolicy;
            return this;
        }

        public Builder setMaxAttempts(int attempts) {
            this.maxAttempts = attempts;
            return this;
        }

        public ExceptionDependentRetry build() {
            return new ExceptionDependentRetry(this.defaultPolicy, this.exceptionNameToPolicyMap, this.maxAttempts);
        }
    }
}

