/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.org.apache.ratis.netty.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.ozone.shaded.org.apache.ratis.client.impl.ClientProtoUtils;
import org.apache.ozone.shaded.org.apache.ratis.netty.NettyConfigKeys;
import org.apache.ozone.shaded.org.apache.ratis.netty.NettyRpcProxy;
import org.apache.ozone.shaded.org.apache.ratis.netty.NettyUtils;
import org.apache.ozone.shaded.org.apache.ratis.proto.RaftProtos;
import org.apache.ozone.shaded.org.apache.ratis.proto.netty.NettyProtos;
import org.apache.ozone.shaded.org.apache.ratis.protocol.GroupInfoReply;
import org.apache.ozone.shaded.org.apache.ratis.protocol.GroupListReply;
import org.apache.ozone.shaded.org.apache.ratis.protocol.RaftClientReply;
import org.apache.ozone.shaded.org.apache.ratis.protocol.RaftPeerId;
import org.apache.ozone.shaded.org.apache.ratis.rpc.SupportedRpcType;
import org.apache.ozone.shaded.org.apache.ratis.server.RaftServer;
import org.apache.ozone.shaded.org.apache.ratis.server.RaftServerRpcWithProxy;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.bootstrap.ServerBootstrap;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.channel.Channel;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.channel.ChannelFuture;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.channel.ChannelHandler;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.channel.ChannelHandlerContext;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.channel.ChannelInitializer;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.channel.ChannelPipeline;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.channel.EventLoopGroup;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.channel.socket.SocketChannel;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.handler.codec.protobuf.ProtobufDecoder;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.handler.codec.protobuf.ProtobufEncoder;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.handler.codec.protobuf.ProtobufVarint32FrameDecoder;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.handler.codec.protobuf.ProtobufVarint32LengthFieldPrepender;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.handler.logging.LogLevel;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.handler.logging.LoggingHandler;
import org.apache.ozone.shaded.org.apache.ratis.util.CodeInjectionForTesting;
import org.apache.ozone.shaded.org.apache.ratis.util.JavaUtils;
import org.apache.ozone.shaded.org.apache.ratis.util.MemoizedSupplier;
import org.apache.ozone.shaded.org.apache.ratis.util.ProtoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NettyRpcService
extends RaftServerRpcWithProxy<NettyRpcProxy, NettyRpcProxy.PeerMap> {
    public static final Logger LOG = LoggerFactory.getLogger(NettyRpcService.class);
    static final String CLASS_NAME = JavaUtils.getClassSimpleName(NettyRpcService.class);
    public static final String SEND_SERVER_REQUEST = CLASS_NAME + ".sendServerRequest";
    private final RaftServer server;
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;
    private final MemoizedSupplier<ChannelFuture> channel;
    private final InetSocketAddress socketAddress;

    public static Builder newBuilder() {
        return new Builder();
    }

    private NettyRpcService(RaftServer server) {
        super(server::getId, (RaftPeerId id) -> new NettyRpcProxy.PeerMap(id.toString(), server.getProperties()));
        this.server = server;
        ChannelInitializer<SocketChannel> initializer = new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel ch) {
                ChannelPipeline p = ch.pipeline();
                p.addLast(new ProtobufVarint32FrameDecoder());
                p.addLast(new ProtobufDecoder(NettyProtos.RaftNettyServerRequestProto.getDefaultInstance()));
                p.addLast(new ProtobufVarint32LengthFieldPrepender());
                p.addLast(new ProtobufEncoder());
                p.addLast(new InboundHandler());
            }
        };
        boolean useEpoll = NettyConfigKeys.Server.useEpoll(server.getProperties());
        this.bossGroup = NettyUtils.newEventLoopGroup(CLASS_NAME + "-bossGroup", 0, useEpoll);
        this.workerGroup = NettyUtils.newEventLoopGroup(CLASS_NAME + "-workerGroup", 0, useEpoll);
        String host = NettyConfigKeys.Server.host(server.getProperties());
        int port = NettyConfigKeys.Server.port(server.getProperties());
        this.socketAddress = host == null || host.isEmpty() ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
        this.channel = JavaUtils.memoize(() -> ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.workerGroup).channel(NettyUtils.getServerChannelClass(this.bossGroup))).handler(new LoggingHandler(LogLevel.INFO))).childHandler(initializer).bind(this.socketAddress));
    }

    @Override
    public SupportedRpcType getRpcType() {
        return SupportedRpcType.NETTY;
    }

    private Channel getChannel() {
        if (!this.channel.isInitialized()) {
            throw new IllegalStateException(this.getId() + ": Failed to getChannel since the service is not yet started");
        }
        return this.channel.get().awaitUninterruptibly().channel();
    }

    @Override
    public void startImpl() throws IOException {
        try {
            this.channel.get().syncUninterruptibly();
        }
        catch (Exception t2) {
            throw new IOException(this.getId() + ": Failed to start " + JavaUtils.getClassSimpleName(this.getClass()), t2);
        }
    }

    @Override
    public void closeImpl() throws IOException {
        ChannelFuture f = this.getChannel().close();
        f.syncUninterruptibly();
        this.bossGroup.shutdownGracefully(0L, 100L, TimeUnit.MILLISECONDS);
        this.workerGroup.shutdownGracefully(0L, 100L, TimeUnit.MILLISECONDS);
        try {
            this.bossGroup.awaitTermination(1000L, TimeUnit.MILLISECONDS);
            this.workerGroup.awaitTermination(1000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            LOG.error("Interrupt EventLoopGroup terminate", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        super.closeImpl();
    }

    @Override
    public InetSocketAddress getInetSocketAddress() {
        try {
            return (InetSocketAddress)this.getChannel().localAddress();
        }
        catch (IllegalStateException e) {
            if (this.socketAddress.getPort() != 0) {
                return this.socketAddress;
            }
            throw e;
        }
    }

    NettyProtos.RaftNettyServerReplyProto handle(NettyProtos.RaftNettyServerRequestProto proto) {
        RaftProtos.RaftRpcRequestProto rpcRequest = null;
        try {
            switch (proto.getRaftNettyServerRequestCase()) {
                case REQUESTVOTEREQUEST: {
                    RaftProtos.RequestVoteRequestProto request = proto.getRequestVoteRequest();
                    rpcRequest = request.getServerRequest();
                    RaftProtos.RequestVoteReplyProto reply = this.server.requestVote(request);
                    return NettyProtos.RaftNettyServerReplyProto.newBuilder().setRequestVoteReply(reply).build();
                }
                case TRANSFERLEADERSHIPREQUEST: {
                    RaftProtos.TransferLeadershipRequestProto transferLeadershipRequest = proto.getTransferLeadershipRequest();
                    rpcRequest = transferLeadershipRequest.getRpcRequest();
                    RaftClientReply transferLeadershipReply = this.server.transferLeadership(ClientProtoUtils.toTransferLeadershipRequest(transferLeadershipRequest));
                    return NettyProtos.RaftNettyServerReplyProto.newBuilder().setRaftClientReply(ClientProtoUtils.toRaftClientReplyProto(transferLeadershipReply)).build();
                }
                case STARTLEADERELECTIONREQUEST: {
                    RaftProtos.StartLeaderElectionRequestProto startLeaderElectionRequest = proto.getStartLeaderElectionRequest();
                    rpcRequest = startLeaderElectionRequest.getServerRequest();
                    RaftProtos.StartLeaderElectionReplyProto startLeaderElectionReply = this.server.startLeaderElection(startLeaderElectionRequest);
                    return NettyProtos.RaftNettyServerReplyProto.newBuilder().setStartLeaderElectionReply(startLeaderElectionReply).build();
                }
                case SNAPSHOTMANAGEMENTREQUEST: {
                    RaftProtos.SnapshotManagementRequestProto snapshotManagementRequest = proto.getSnapshotManagementRequest();
                    rpcRequest = snapshotManagementRequest.getRpcRequest();
                    RaftClientReply snapshotManagementReply = this.server.snapshotManagement(ClientProtoUtils.toSnapshotManagementRequest(snapshotManagementRequest));
                    return NettyProtos.RaftNettyServerReplyProto.newBuilder().setRaftClientReply(ClientProtoUtils.toRaftClientReplyProto(snapshotManagementReply)).build();
                }
                case LEADERELECTIONMANAGEMENTREQUEST: {
                    RaftProtos.LeaderElectionManagementRequestProto leaderElectionManagementRequest = proto.getLeaderElectionManagementRequest();
                    rpcRequest = leaderElectionManagementRequest.getRpcRequest();
                    RaftClientReply leaderElectionManagementReply = this.server.leaderElectionManagement(ClientProtoUtils.toLeaderElectionManagementRequest(leaderElectionManagementRequest));
                    return NettyProtos.RaftNettyServerReplyProto.newBuilder().setRaftClientReply(ClientProtoUtils.toRaftClientReplyProto(leaderElectionManagementReply)).build();
                }
                case APPENDENTRIESREQUEST: {
                    RaftProtos.AppendEntriesRequestProto appendEntriesRequest = proto.getAppendEntriesRequest();
                    rpcRequest = appendEntriesRequest.getServerRequest();
                    RaftProtos.AppendEntriesReplyProto appendEntriesReply = this.server.appendEntries(appendEntriesRequest);
                    return NettyProtos.RaftNettyServerReplyProto.newBuilder().setAppendEntriesReply(appendEntriesReply).build();
                }
                case INSTALLSNAPSHOTREQUEST: {
                    RaftProtos.InstallSnapshotRequestProto installSnapshotRequest = proto.getInstallSnapshotRequest();
                    rpcRequest = installSnapshotRequest.getServerRequest();
                    RaftProtos.InstallSnapshotReplyProto installSnapshotReply = this.server.installSnapshot(installSnapshotRequest);
                    return NettyProtos.RaftNettyServerReplyProto.newBuilder().setInstallSnapshotReply(installSnapshotReply).build();
                }
                case RAFTCLIENTREQUEST: {
                    RaftProtos.RaftClientRequestProto raftClientRequest = proto.getRaftClientRequest();
                    rpcRequest = raftClientRequest.getRpcRequest();
                    RaftClientReply raftClientReply = this.server.submitClientRequest(ClientProtoUtils.toRaftClientRequest(raftClientRequest));
                    return NettyProtos.RaftNettyServerReplyProto.newBuilder().setRaftClientReply(ClientProtoUtils.toRaftClientReplyProto(raftClientReply)).build();
                }
                case SETCONFIGURATIONREQUEST: {
                    RaftProtos.SetConfigurationRequestProto configurationRequest = proto.getSetConfigurationRequest();
                    rpcRequest = configurationRequest.getRpcRequest();
                    RaftClientReply configurationReply = this.server.setConfiguration(ClientProtoUtils.toSetConfigurationRequest(configurationRequest));
                    return NettyProtos.RaftNettyServerReplyProto.newBuilder().setRaftClientReply(ClientProtoUtils.toRaftClientReplyProto(configurationReply)).build();
                }
                case GROUPMANAGEMENTREQUEST: {
                    RaftProtos.GroupManagementRequestProto groupManagementRequest = proto.getGroupManagementRequest();
                    rpcRequest = groupManagementRequest.getRpcRequest();
                    RaftClientReply groupManagementReply = this.server.groupManagement(ClientProtoUtils.toGroupManagementRequest(groupManagementRequest));
                    return NettyProtos.RaftNettyServerReplyProto.newBuilder().setRaftClientReply(ClientProtoUtils.toRaftClientReplyProto(groupManagementReply)).build();
                }
                case GROUPLISTREQUEST: {
                    RaftProtos.GroupListRequestProto groupListRequest = proto.getGroupListRequest();
                    rpcRequest = groupListRequest.getRpcRequest();
                    GroupListReply groupListReply = this.server.getGroupList(ClientProtoUtils.toGroupListRequest(groupListRequest));
                    return NettyProtos.RaftNettyServerReplyProto.newBuilder().setGroupListReply(ClientProtoUtils.toGroupListReplyProto(groupListReply)).build();
                }
                case GROUPINFOREQUEST: {
                    RaftProtos.GroupInfoRequestProto groupInfoRequest = proto.getGroupInfoRequest();
                    rpcRequest = groupInfoRequest.getRpcRequest();
                    GroupInfoReply groupInfoReply = this.server.getGroupInfo(ClientProtoUtils.toGroupInfoRequest(groupInfoRequest));
                    return NettyProtos.RaftNettyServerReplyProto.newBuilder().setGroupInfoReply(ClientProtoUtils.toGroupInfoReplyProto(groupInfoReply)).build();
                }
                case RAFTNETTYSERVERREQUEST_NOT_SET: {
                    throw new IllegalArgumentException("Request case not set in proto: " + proto.getRaftNettyServerRequestCase());
                }
            }
            throw new UnsupportedOperationException("Request case not supported: " + proto.getRaftNettyServerRequestCase());
        }
        catch (IOException ioe) {
            return NettyRpcService.toRaftNettyServerReplyProto(Objects.requireNonNull(rpcRequest, "rpcRequest = null"), ioe);
        }
    }

    private static NettyProtos.RaftNettyServerReplyProto toRaftNettyServerReplyProto(RaftProtos.RaftRpcRequestProto request, IOException e) {
        RaftProtos.RaftRpcReplyProto.Builder rpcReply = RaftProtos.RaftRpcReplyProto.newBuilder().setRequestorId(request.getRequestorId()).setReplyId(request.getReplyId()).setCallId(request.getCallId()).setSuccess(false);
        NettyProtos.RaftNettyExceptionReplyProto.Builder ioe = NettyProtos.RaftNettyExceptionReplyProto.newBuilder().setRpcReply(rpcReply).setException(ProtoUtils.writeObject2ByteString(e));
        return NettyProtos.RaftNettyServerReplyProto.newBuilder().setExceptionReply(ioe).build();
    }

    @Override
    public RaftProtos.RequestVoteReplyProto requestVote(RaftProtos.RequestVoteRequestProto request) throws IOException {
        CodeInjectionForTesting.execute(SEND_SERVER_REQUEST, this.getId(), null, request);
        NettyProtos.RaftNettyServerRequestProto proto = NettyProtos.RaftNettyServerRequestProto.newBuilder().setRequestVoteRequest(request).build();
        RaftProtos.RaftRpcRequestProto serverRequest = request.getServerRequest();
        return this.sendRaftNettyServerRequestProto(serverRequest, proto).getRequestVoteReply();
    }

    @Override
    public RaftProtos.StartLeaderElectionReplyProto startLeaderElection(RaftProtos.StartLeaderElectionRequestProto request) throws IOException {
        CodeInjectionForTesting.execute(SEND_SERVER_REQUEST, this.getId(), null, request);
        NettyProtos.RaftNettyServerRequestProto proto = NettyProtos.RaftNettyServerRequestProto.newBuilder().setStartLeaderElectionRequest(request).build();
        RaftProtos.RaftRpcRequestProto serverRequest = request.getServerRequest();
        return this.sendRaftNettyServerRequestProto(serverRequest, proto).getStartLeaderElectionReply();
    }

    @Override
    public RaftProtos.AppendEntriesReplyProto appendEntries(RaftProtos.AppendEntriesRequestProto request) throws IOException {
        CodeInjectionForTesting.execute(SEND_SERVER_REQUEST, this.getId(), null, request);
        NettyProtos.RaftNettyServerRequestProto proto = NettyProtos.RaftNettyServerRequestProto.newBuilder().setAppendEntriesRequest(request).build();
        RaftProtos.RaftRpcRequestProto serverRequest = request.getServerRequest();
        return this.sendRaftNettyServerRequestProto(serverRequest, proto).getAppendEntriesReply();
    }

    @Override
    public RaftProtos.InstallSnapshotReplyProto installSnapshot(RaftProtos.InstallSnapshotRequestProto request) throws IOException {
        CodeInjectionForTesting.execute(SEND_SERVER_REQUEST, this.getId(), null, request);
        NettyProtos.RaftNettyServerRequestProto proto = NettyProtos.RaftNettyServerRequestProto.newBuilder().setInstallSnapshotRequest(request).build();
        RaftProtos.RaftRpcRequestProto serverRequest = request.getServerRequest();
        return this.sendRaftNettyServerRequestProto(serverRequest, proto).getInstallSnapshotReply();
    }

    private NettyProtos.RaftNettyServerReplyProto sendRaftNettyServerRequestProto(RaftProtos.RaftRpcRequestProto request, NettyProtos.RaftNettyServerRequestProto proto) throws IOException {
        RaftPeerId id = RaftPeerId.valueOf(request.getReplyId());
        try {
            NettyRpcProxy p = (NettyRpcProxy)((NettyRpcProxy.PeerMap)this.getProxies()).getProxy(id);
            return p.send(request, proto);
        }
        catch (Exception e) {
            ((NettyRpcProxy.PeerMap)this.getProxies()).handleException(id, e, false);
            throw e;
        }
    }

    @ChannelHandler.Sharable
    class InboundHandler
    extends SimpleChannelInboundHandler<NettyProtos.RaftNettyServerRequestProto> {
        InboundHandler() {
        }

        @Override
        protected void channelRead0(ChannelHandlerContext ctx, NettyProtos.RaftNettyServerRequestProto proto) {
            NettyProtos.RaftNettyServerReplyProto reply = NettyRpcService.this.handle(proto);
            ctx.writeAndFlush(reply);
        }
    }

    public static final class Builder {
        private RaftServer server;

        private Builder() {
        }

        public Builder setServer(RaftServer raftServer) {
            this.server = raftServer;
            return this;
        }

        public NettyRpcService build() {
            return new NettyRpcService(this.server);
        }
    }
}

