/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.org.apache.ratis.netty;

import java.util.Optional;
import org.apache.ozone.shaded.org.apache.ratis.client.DataStreamClientFactory;
import org.apache.ozone.shaded.org.apache.ratis.client.DataStreamClientRpc;
import org.apache.ozone.shaded.org.apache.ratis.conf.Parameters;
import org.apache.ozone.shaded.org.apache.ratis.conf.RaftProperties;
import org.apache.ozone.shaded.org.apache.ratis.datastream.SupportedDataStreamType;
import org.apache.ozone.shaded.org.apache.ratis.netty.NettyConfigKeys;
import org.apache.ozone.shaded.org.apache.ratis.netty.client.NettyClientStreamRpc;
import org.apache.ozone.shaded.org.apache.ratis.netty.server.NettyServerStreamRpc;
import org.apache.ozone.shaded.org.apache.ratis.protocol.RaftPeer;
import org.apache.ozone.shaded.org.apache.ratis.server.DataStreamServerFactory;
import org.apache.ozone.shaded.org.apache.ratis.server.DataStreamServerRpc;
import org.apache.ozone.shaded.org.apache.ratis.server.RaftServer;

public class NettyDataStreamFactory
implements DataStreamServerFactory,
DataStreamClientFactory {
    private final Parameters parameters;

    public NettyDataStreamFactory(Parameters parameters) {
        this.parameters = Optional.ofNullable(parameters).orElseGet(Parameters::new);
    }

    @Override
    public SupportedDataStreamType getDataStreamType() {
        return SupportedDataStreamType.NETTY;
    }

    @Override
    public DataStreamClientRpc newDataStreamClientRpc(RaftPeer server, RaftProperties properties) {
        return new NettyClientStreamRpc(server, NettyConfigKeys.DataStream.Client.tlsConf(this.parameters), properties);
    }

    @Override
    public DataStreamServerRpc newDataStreamServerRpc(RaftServer server) {
        return new NettyServerStreamRpc(server, this.parameters);
    }
}

