/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.org.apache.ratis.grpc.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.com.google.protobuf.CodedInputStream;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.com.google.protobuf.MessageLite;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.com.google.protobuf.Parser;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.grpc.Detachable;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.grpc.HasByteBuffer;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.grpc.KnownLength;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.grpc.MethodDescriptor;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.grpc.Status;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.grpc.protobuf.lite.ProtoLiteUtils;
import org.apache.ozone.shaded.org.apache.ratis.util.JavaUtils;
import org.apache.ozone.shaded.org.apache.ratis.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeroCopyMessageMarshaller<T extends MessageLite>
implements MethodDescriptor.PrototypeMarshaller<T> {
    static final Logger LOG = LoggerFactory.getLogger(ZeroCopyMessageMarshaller.class);
    private final String name;
    private final Map<T, InputStream> unclosedStreams = Collections.synchronizedMap(new IdentityHashMap());
    private final Parser<T> parser;
    private final MethodDescriptor.PrototypeMarshaller<T> marshaller;
    private final Consumer<T> zeroCopyCount;
    private final Consumer<T> nonZeroCopyCount;

    public ZeroCopyMessageMarshaller(T defaultInstance) {
        this((MessageLite)defaultInstance, m4 -> {}, m4 -> {});
    }

    public ZeroCopyMessageMarshaller(T defaultInstance, Consumer<T> zeroCopyCount, Consumer<T> nonZeroCopyCount) {
        this.name = JavaUtils.getClassSimpleName(defaultInstance.getClass()) + "-Marshaller";
        Parser<? extends MessageLite> p = defaultInstance.getParserForType();
        this.parser = p;
        this.marshaller = (MethodDescriptor.PrototypeMarshaller)ProtoLiteUtils.marshaller(defaultInstance);
        this.zeroCopyCount = zeroCopyCount;
        this.nonZeroCopyCount = nonZeroCopyCount;
    }

    @Override
    public Class<T> getMessageClass() {
        return this.marshaller.getMessageClass();
    }

    @Override
    public T getMessagePrototype() {
        return (T)((MessageLite)this.marshaller.getMessagePrototype());
    }

    @Override
    public InputStream stream(T value) {
        return this.marshaller.stream(value);
    }

    @Override
    public T parse(InputStream stream) {
        T message;
        try {
            message = this.parseZeroCopy(stream);
        }
        catch (IOException e) {
            throw Status.INTERNAL.withDescription("Failed to parseZeroCopy").withCause(e).asRuntimeException();
        }
        if (message != null) {
            this.zeroCopyCount.accept(message);
            return message;
        }
        MessageLite copied = (MessageLite)this.marshaller.parse(stream);
        this.nonZeroCopyCount.accept(copied);
        return (T)copied;
    }

    public void release(T message) {
        InputStream stream = this.popStream(message);
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (IOException e) {
            LOG.error(this.name + ": Failed to close stream.", (Throwable)e);
        }
    }

    private List<ByteString> getByteStrings(InputStream detached, int exactSize) throws IOException {
        Preconditions.assertTrue(detached instanceof HasByteBuffer);
        detached.mark(exactSize);
        LinkedList<ByteString> byteStrings = new LinkedList<ByteString>();
        while (detached.available() != 0) {
            ByteBuffer buffer = ((HasByteBuffer)((Object)detached)).getByteBuffer();
            Objects.requireNonNull(buffer, "buffer == null");
            byteStrings.add(UnsafeByteOperations.unsafeWrap(buffer));
            int remaining = buffer.remaining();
            long skipped = detached.skip(buffer.remaining());
            Preconditions.assertSame((long)remaining, skipped, "skipped");
        }
        detached.reset();
        return byteStrings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T parseZeroCopy(InputStream stream) throws IOException {
        if (!(stream instanceof KnownLength)) {
            LOG.debug("stream is not KnownLength: {}", stream.getClass());
            return null;
        }
        if (!(stream instanceof Detachable)) {
            LOG.debug("stream is not Detachable: {}", stream.getClass());
            return null;
        }
        if (!(stream instanceof HasByteBuffer)) {
            LOG.debug("stream is not HasByteBuffer: {}", stream.getClass());
            return null;
        }
        if (!((HasByteBuffer)((Object)stream)).byteBufferSupported()) {
            LOG.debug("stream is HasByteBuffer but not byteBufferSupported: {}", stream.getClass());
            return null;
        }
        int exactSize = stream.available();
        try (InputStream detached = ((Detachable)((Object)stream)).detach();){
            List<ByteString> byteStrings = this.getByteStrings(detached, exactSize);
            T message = this.parseFrom(byteStrings, exactSize);
            InputStream previous = this.unclosedStreams.put(message, detached);
            Preconditions.assertNull((Object)previous, "previous");
            detached = null;
            T t2 = message;
            return t2;
        }
    }

    private T parseFrom(List<ByteString> byteStrings, int exactSize) {
        CodedInputStream codedInputStream = ByteString.copyFrom(byteStrings).newCodedInput();
        codedInputStream.enableAliasing(true);
        codedInputStream.setSizeLimit(exactSize);
        try {
            return this.parseFrom(codedInputStream);
        }
        catch (InvalidProtocolBufferException e) {
            throw Status.INTERNAL.withDescription("Invalid protobuf byte sequence").withCause(e).asRuntimeException();
        }
    }

    private T parseFrom(CodedInputStream stream) throws InvalidProtocolBufferException {
        MessageLite message = (MessageLite)this.parser.parseFrom(stream);
        try {
            stream.checkLastTagWas(0);
            return (T)message;
        }
        catch (InvalidProtocolBufferException e) {
            e.setUnfinishedMessage(message);
            throw e;
        }
    }

    public InputStream popStream(T message) {
        return this.unclosedStreams.remove(message);
    }
}

