/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.org.apache.ratis.grpc.util;

import java.util.function.Consumer;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.grpc.CallOptions;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.grpc.Channel;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.grpc.ClientCall;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.grpc.ClientInterceptor;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.grpc.ForwardingClientCall;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.grpc.ForwardingClientCallListener;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.grpc.Metadata;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.grpc.MethodDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseNotifyClientInterceptor
implements ClientInterceptor {
    public static final Logger LOG = LoggerFactory.getLogger(ResponseNotifyClientInterceptor.class);
    private final Consumer<Object> notifier;

    public ResponseNotifyClientInterceptor(Consumer<Object> notifier) {
        this.notifier = notifier;
    }

    @Override
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        LOG.debug("callOptions {}", (Object)callOptions);
        return new Call(next.newCall(method, callOptions));
    }

    private final class Call<ReqT, RespT>
    extends ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT> {
        private Call(ClientCall<ReqT, RespT> delegate) {
            super(delegate);
        }

        @Override
        public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
            LOG.debug("start {}", (Object)headers);
            super.start(new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                @Override
                public void onMessage(RespT message) {
                    LOG.debug("onMessage {}", message);
                    ResponseNotifyClientInterceptor.this.notifier.accept(message);
                    super.onMessage(message);
                }
            }, headers);
        }
    }
}

