/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.org.apache.ratis.grpc.metrics;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ozone.shaded.org.apache.ratis.metrics.LongCounter;
import org.apache.ozone.shaded.org.apache.ratis.metrics.MetricRegistryInfo;
import org.apache.ozone.shaded.org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ozone.shaded.org.apache.ratis.metrics.RatisMetrics;
import org.apache.ozone.shaded.org.apache.ratis.metrics.Timekeeper;

public class GrpcServerMetrics
extends RatisMetrics {
    private static final String RATIS_GRPC_METRICS_APP_NAME = "ratis_grpc";
    private static final String RATIS_GRPC_METRICS_COMP_NAME = "log_appender";
    private static final String RATIS_GRPC_METRICS_DESC = "Metrics for Ratis Grpc Log Appender";
    public static final String RATIS_GRPC_METRICS_LOG_APPENDER_LATENCY = "%s_latency";
    public static final String RATIS_GRPC_METRICS_LOG_APPENDER_SUCCESS = "%s_success_reply_count";
    public static final String RATIS_GRPC_METRICS_LOG_APPENDER_NOT_LEADER = "%s_not_leader_reply_count";
    public static final String RATIS_GRPC_METRICS_LOG_APPENDER_INCONSISTENCY = "%s_inconsistency_reply_count";
    public static final String RATIS_GRPC_METRICS_LOG_APPENDER_TIMEOUT = "%s_append_entry_timeout_count";
    public static final String RATIS_GRPC_METRICS_LOG_APPENDER_PENDING_COUNT = "%s_pending_log_requests_count";
    public static final String RATIS_GRPC_METRICS_REQUEST_RETRY_COUNT = "num_retries";
    public static final String RATIS_GRPC_METRICS_REQUESTS_COUNT = "num_requests";
    public static final String RATIS_GRPC_INSTALL_SNAPSHOT_COUNT = "num_install_snapshot";
    private final LongCounter requestRetry = this.getRegistry().counter("num_retries");
    private final LongCounter requestInstallSnapshot = this.getRegistry().counter("num_install_snapshot");
    private final Function<Boolean, LongCounter> requestCreate = this.newHeartbeatCounter("num_requests");
    private final Map<String, Function<Boolean, LongCounter>> requestSuccess = new ConcurrentHashMap<String, Function<Boolean, LongCounter>>();
    private final Map<String, Function<Boolean, LongCounter>> requestTimeout = new ConcurrentHashMap<String, Function<Boolean, LongCounter>>();
    private final Map<String, LongCounter> requestNotLeader = new ConcurrentHashMap<String, LongCounter>();
    private final Map<String, LongCounter> requestInconsistency = new ConcurrentHashMap<String, LongCounter>();
    private final Map<String, String> heartbeatLatency = new ConcurrentHashMap<String, String>();
    private final Map<String, String> appendLogLatency = new ConcurrentHashMap<String, String>();

    public GrpcServerMetrics(String serverId) {
        super(GrpcServerMetrics.createRegistry(serverId));
    }

    private static RatisMetricRegistry createRegistry(String serverId) {
        return GrpcServerMetrics.create(new MetricRegistryInfo(serverId, RATIS_GRPC_METRICS_APP_NAME, RATIS_GRPC_METRICS_COMP_NAME, RATIS_GRPC_METRICS_DESC));
    }

    public Timekeeper getGrpcLogAppenderLatencyTimer(String follower, boolean isHeartbeat) {
        Map<String, String> map = isHeartbeat ? this.heartbeatLatency : this.appendLogLatency;
        String name = map.computeIfAbsent(follower, key -> String.format(RATIS_GRPC_METRICS_LOG_APPENDER_LATENCY + GrpcServerMetrics.getHeartbeatSuffix(isHeartbeat), key));
        return this.getRegistry().timer(name);
    }

    public void onRequestRetry() {
        this.requestRetry.inc();
    }

    public void onRequestCreate(boolean isHeartbeat) {
        this.requestCreate.apply(isHeartbeat).inc();
    }

    private Function<Boolean, LongCounter> newRequestSuccess(String follower) {
        String prefix = String.format(RATIS_GRPC_METRICS_LOG_APPENDER_SUCCESS, follower);
        return this.newHeartbeatCounter(prefix);
    }

    public void onRequestSuccess(String follower, boolean isHeartbeat) {
        ((LongCounter)this.requestSuccess.computeIfAbsent(follower, this::newRequestSuccess).apply(isHeartbeat)).inc();
    }

    private LongCounter newRequestNotLeader(String follower) {
        return this.getRegistry().counter(String.format(RATIS_GRPC_METRICS_LOG_APPENDER_NOT_LEADER, follower));
    }

    public void onRequestNotLeader(String follower) {
        this.requestNotLeader.computeIfAbsent(follower, this::newRequestNotLeader).inc();
    }

    private LongCounter newRequestInconsistency(String follower) {
        return this.getRegistry().counter(String.format(RATIS_GRPC_METRICS_LOG_APPENDER_INCONSISTENCY, follower));
    }

    public void onRequestInconsistency(String follower) {
        this.requestInconsistency.computeIfAbsent(follower, this::newRequestInconsistency).inc();
    }

    private Function<Boolean, LongCounter> newRequestTimeout(String follower) {
        String prefix = String.format(RATIS_GRPC_METRICS_LOG_APPENDER_TIMEOUT, follower);
        return this.newHeartbeatCounter(prefix);
    }

    public void onRequestTimeout(String follower, boolean isHeartbeat) {
        ((LongCounter)this.requestTimeout.computeIfAbsent(follower, this::newRequestTimeout).apply(isHeartbeat)).inc();
    }

    public void addPendingRequestsCount(String follower, Supplier<Integer> pendinglogQueueSize) {
        String name = String.format(RATIS_GRPC_METRICS_LOG_APPENDER_PENDING_COUNT, follower);
        this.getRegistry().gauge(name, () -> pendinglogQueueSize);
    }

    public void onInstallSnapshot() {
        this.requestInstallSnapshot.inc();
    }
}

