/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.io.opentelemetry.sdk.metrics;

import java.util.function.Consumer;
import org.apache.ozone.shaded.io.opentelemetry.api.common.Attributes;
import org.apache.ozone.shaded.io.opentelemetry.api.metrics.DoubleGauge;
import org.apache.ozone.shaded.io.opentelemetry.api.metrics.DoubleGaugeBuilder;
import org.apache.ozone.shaded.io.opentelemetry.api.metrics.LongGaugeBuilder;
import org.apache.ozone.shaded.io.opentelemetry.api.metrics.ObservableDoubleGauge;
import org.apache.ozone.shaded.io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import org.apache.ozone.shaded.io.opentelemetry.context.Context;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.AbstractInstrument;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.InstrumentBuilder;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.InstrumentType;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.InstrumentValueType;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.SdkLongGauge;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.SdkMeter;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;

class SdkDoubleGauge
extends AbstractInstrument
implements DoubleGauge {
    final SdkMeter sdkMeter;
    final WriteableMetricStorage storage;

    SdkDoubleGauge(InstrumentDescriptor descriptor, SdkMeter sdkMeter, WriteableMetricStorage storage) {
        super(descriptor);
        this.sdkMeter = sdkMeter;
        this.storage = storage;
    }

    @Override
    public void set(double value, Attributes attributes) {
        this.storage.recordDouble(value, attributes, Context.current());
    }

    @Override
    public void set(double value, Attributes attributes, Context context) {
        this.storage.recordDouble(value, attributes, context);
    }

    @Override
    public void set(double value) {
        this.set(value, Attributes.empty());
    }

    static class SdkDoubleGaugeBuilder
    implements DoubleGaugeBuilder {
        final InstrumentBuilder builder;

        SdkDoubleGaugeBuilder(SdkMeter sdkMeter, String name) {
            this.builder = new InstrumentBuilder(name, InstrumentType.GAUGE, InstrumentValueType.DOUBLE, sdkMeter);
        }

        @Override
        public DoubleGaugeBuilder setDescription(String description) {
            this.builder.setDescription(description);
            return this;
        }

        @Override
        public DoubleGaugeBuilder setUnit(String unit) {
            this.builder.setUnit(unit);
            return this;
        }

        @Override
        public SdkDoubleGauge build() {
            return this.builder.buildSynchronousInstrument(SdkDoubleGauge::new);
        }

        @Override
        public LongGaugeBuilder ofLongs() {
            return this.builder.swapBuilder(SdkLongGauge.SdkLongGaugeBuilder::new);
        }

        @Override
        public ObservableDoubleGauge buildWithCallback(Consumer<ObservableDoubleMeasurement> callback) {
            return this.builder.buildDoubleAsynchronousInstrument(InstrumentType.OBSERVABLE_GAUGE, callback);
        }

        @Override
        public ObservableDoubleMeasurement buildObserver() {
            return this.builder.buildObservableMeasurement(InstrumentType.OBSERVABLE_GAUGE);
        }

        public String toString() {
            return this.builder.toStringHelper(this.getClass().getSimpleName());
        }
    }
}

